/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorFilterDecimalScalarLessThanOrEqualsDecimalColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private BigDecimal value;

    public XVectorFilterDecimalScalarLessThanOrEqualsDecimalColumn(BigDecimal inValue, int inColNum) {
        this.value = inValue;
        this.columnNo = inColNum;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.columns[this.columnNo];
        BigDecimal[] vector = inputColVector.vector;
        boolean[] isNull = inputColVector.isNull;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (this.value.compareTo(vector[0]) > 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (this.value.compareTo(vector[i]) > 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (this.value.compareTo(vector[i]) > 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!isNull[0]) {
                if (this.value.compareTo(vector[0]) > 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || this.value.compareTo(vector[i]) > 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || this.value.compareTo(vector[i]) > 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = new BigDecimal(inputNode.attributeValue("value"));
    }
}

