/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorFilterDoubleColumnNotBetween
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_LEFTVALUE = "leftValue";
    private static final String ATTRIBUTE_RIGHTVALUE = "rightValue";
    private int columnNo;
    private double leftValue;
    private double rightValue;

    public XVectorFilterDoubleColumnNotBetween(int theColumnNo, Number theLeftValue, Number theRightValue) {
        this.columnNo = theColumnNo;
        this.leftValue = theLeftValue.doubleValue();
        this.rightValue = theRightValue.doubleValue();
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.columns[this.columnNo];
        boolean[] nullPos = inputColVector.isNull;
        double[] vector = inputColVector.vector;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!(vector[0] < this.leftValue) && !(vector[0] > this.rightValue)) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (this.leftValue <= vector[i] && vector[i] <= this.rightValue) continue;
                    selected[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (this.leftValue <= vector[i] && vector[i] <= this.rightValue) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!(vector[0] < this.leftValue) && !(vector[0] > this.rightValue)) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (nullPos[i] || this.leftValue <= vector[i] && vector[i] <= this.rightValue) continue;
                selected[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || this.leftValue <= vector[i] && vector[i] <= this.rightValue) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.columnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
        trace.attribute(ATTRIBUTE_LEFTVALUE, String.valueOf(this.leftValue));
        trace.attribute(ATTRIBUTE_RIGHTVALUE, String.valueOf(this.rightValue));
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        this.leftValue = Long.valueOf(inputNode.attributeValue(ATTRIBUTE_LEFTVALUE)).longValue();
        this.rightValue = Long.valueOf(inputNode.attributeValue(ATTRIBUTE_RIGHTVALUE)).longValue();
        super.capture(env, inputNode);
    }
}

