/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorFilterTimestampColumnBetween
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_LEFTVALUE = "leftValue";
    private static final String ATTRIBUTE_RIGHTVALUE = "rightValue";
    private int columnNo;
    private TimestampColumnVector.UnixTimestamp leftValue;
    private TimestampColumnVector.UnixTimestamp rightValue;

    public XVectorFilterTimestampColumnBetween(int theColumnNo, TimestampColumnVector.UnixTimestamp theLeftValue, TimestampColumnVector.UnixTimestamp theRightValue) {
        this.columnNo = theColumnNo;
        this.leftValue = theLeftValue;
        this.rightValue = theRightValue;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.columns[this.columnNo];
        boolean[] nullPos = inputColVector.isNull;
        TimestampColumnVector.UnixTimestamp[] vector = inputColVector.vector;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (vector[0].compareTo(this.leftValue) < 0 || vector[0].compareTo(this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (vector[i].compareTo(this.leftValue) < 0 || vector[i].compareTo(this.rightValue) > 0) continue;
                    selected[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector[i].compareTo(this.leftValue) < 0 || vector[i].compareTo(this.rightValue) > 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (vector[0].compareTo(this.leftValue) < 0 || vector[0].compareTo(this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (nullPos[i] || vector[i].compareTo(this.leftValue) < 0 || vector[i].compareTo(this.rightValue) > 0) continue;
                selected[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || vector[i].compareTo(this.leftValue) < 0 || vector[i].compareTo(this.rightValue) > 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        super.capture(env, inputNode);
    }
}

