/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorFilterTimestampColumnLessThanTimestampColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;

    public XVectorFilterTimestampColumnLessThanTimestampColumn(int inColNum1, int inColNum2) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.columns[this.colNum1];
        TimestampColumnVector inputColVector2 = (TimestampColumnVector)batch.columns[this.colNum2];
        TimestampColumnVector.UnixTimestamp[] vector1 = inputColVector1.vector;
        TimestampColumnVector.UnixTimestamp[] vector2 = inputColVector2.vector;
        int newSize = NullUtil.filterNulls(batch.columns[this.colNum1], batch.selectedInUse, selected, n);
        if (newSize < n) {
            batch.size = newSize;
            n = newSize;
            batch.selectedInUse = true;
        }
        if ((newSize = NullUtil.filterNulls(batch.columns[this.colNum2], batch.selectedInUse, selected, n)) < n) {
            batch.size = newSize;
            n = newSize;
            batch.selectedInUse = true;
        }
        if (n != 0 && inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (vector1[0].compareTo(vector2[0]) >= 0) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (vector1[0].compareTo(vector2[i]) >= 0) continue;
                    selected[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector1[0].compareTo(vector2[i]) >= 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    if (vector1[i].compareTo(vector2[0]) >= 0) continue;
                    selected[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector1[i].compareTo(vector2[0]) >= 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                if (vector1[i].compareTo(vector2[i]) >= 0) continue;
                selected[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (vector1[i].compareTo(vector2[i]) >= 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("leftColumnNo", this.colNum1);
        trace.attribute("rightColumnNo", this.colNum2);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.colNum2 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        super.capture(env, inputNode);
    }
}

