/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorFunctionCeilingLong
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    public XVectorFunctionCeilingLong(int inColumnNo, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        LongColumnVector inputColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
            outputColumnVector.setFormatID("Undefined", inputColumnVector.getFormatId());
        }
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        long[] vector = inputColumnVector.vector;
        long[] outputVector = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputVector[0] = (long)StrictMath.ceil(vector[0]);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = (long)StrictMath.ceil(vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (long)StrictMath.ceil(vector[i]);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = (long)StrictMath.ceil(vector[i]);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = (long)StrictMath.ceil(vector[i]);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

