/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public abstract class XVectorFunctionLongToString
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputColumnNo;
    private int outputColumnNo;

    public XVectorFunctionLongToString(int inColumnNo, int outColumnNo) {
        this.inputColumnNo = inColumnNo;
        this.outputColumnNo = outColumnNo;
    }

    protected abstract void getResult(StringColumnVector var1, LongColumnVector var2, int var3);

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        block13: {
            int[] selected;
            boolean[] outputIsNull;
            boolean[] inputIsNull;
            StringColumnVector outputColumnVector;
            LongColumnVector inputColumnVector;
            int n;
            block14: {
                block12: {
                    super.evaluate(context, batch);
                    n = batch.size;
                    if (n == 0) {
                        return;
                    }
                    inputColumnVector = (LongColumnVector)batch.columns[this.inputColumnNo];
                    outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
                    if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                        outputColumnVector.setFormatID(inputColumnVector.getFormatId());
                    }
                    inputIsNull = inputColumnVector.isNull;
                    outputIsNull = outputColumnVector.isNull;
                    selected = batch.selected;
                    outputColumnVector.isRepeating = inputColumnVector.isRepeating;
                    if (!inputColumnVector.noNulls) break block12;
                    outputColumnVector.noNulls = true;
                    if (inputColumnVector.isRepeating) {
                        this.getResult(outputColumnVector, inputColumnVector, 0);
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = selected[j];
                            this.getResult(outputColumnVector, inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i != n; ++i) {
                            this.getResult(outputColumnVector, inputColumnVector, i);
                        }
                    }
                    break block13;
                }
                outputColumnVector.noNulls = false;
                if (!inputColumnVector.isRepeating) break block14;
                outputIsNull[0] = inputIsNull[0];
                if (inputIsNull[0]) break block13;
                this.getResult(outputColumnVector, inputColumnVector, 0);
                break block13;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    this.getResult(outputColumnVector, inputColumnVector, i);
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumnNo = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumnNo;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumnNo = inputColumn;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.inputColumnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        trace.attribute("dataType", this.dataType.toString());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

