/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorIntervalColumnLessThanOrEqualsIntervalScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private IntervalColumnVector.IntervalStruct value;

    public XVectorIntervalColumnLessThanOrEqualsIntervalScalar(int inColNum, IntervalColumnVector.IntervalStruct inValue, int inOutputColumnNo) {
        this.columnNo = inColNum;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        IntervalColumnVector inputColVector = (IntervalColumnVector)batch.columns[this.columnNo];
        IntervalColumnVector.IntervalStruct[] vector = inputColVector.vector;
        boolean[] isNull = inputColVector.isNull;
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        long[] outputVector = outputColumnVector.vector;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.isRepeating = inputColVector.isRepeating;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = vector[0].compareTo(this.value) <= 0 ? 1L : 0L;
            } else if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector[i].compareTo(this.value) <= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputVector[i] = vector[i].compareTo(this.value) <= 0 ? 1L : 0L;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!isNull[0]) {
                outputVector[0] = vector[0].compareTo(this.value) > 0 ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (!isNull[i]) {
                    if (vector[i].compareTo(this.value) <= 0) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputIsNull[i] = true;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!isNull[i]) {
                    if (vector[i].compareTo(this.value) <= 0) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputIsNull[i] = true;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
    }
}

