/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.TimestampUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorIntervalColumnSafeDivideDoubleColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColNum;
    private TimestampUtil tsUtil = new TimestampUtil();

    public XVectorIntervalColumnSafeDivideDoubleColumn(int inColNum1, int inColNum2, int inOutputColNum) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
        this.outputColNum = inOutputColNum;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        block14: {
            double[] vector2;
            IntervalColumnVector.IntervalStruct[] vector1;
            int[] selected;
            IntervalColumnVector outputColumnVector;
            DoubleColumnVector inputColumnVector2;
            IntervalColumnVector inputColumnVector1;
            int n;
            block16: {
                block15: {
                    block13: {
                        super.evaluate(context, batch);
                        n = batch.size;
                        if (n == 0) {
                            return;
                        }
                        inputColumnVector1 = (IntervalColumnVector)batch.columns[this.colNum1];
                        inputColumnVector2 = (DoubleColumnVector)batch.columns[this.colNum2];
                        outputColumnVector = (IntervalColumnVector)batch.columns[this.outputColNum];
                        selected = batch.selected;
                        vector1 = inputColumnVector1.vector;
                        vector2 = inputColumnVector2.vector;
                        IntervalColumnVector.IntervalStruct[] outputVector = outputColumnVector.vector;
                        boolean[] input1IsNull = inputColumnVector1.isNull;
                        boolean[] input2IsNull = inputColumnVector2.isNull;
                        boolean[] outputIsNull = outputColumnVector.isNull;
                        outputColumnVector.isRepeating = inputColumnVector1.isRepeating && inputColumnVector2.isRepeating || inputColumnVector1.isRepeating && !inputColumnVector1.noNulls && inputColumnVector1.isNull[0] || inputColumnVector2.isRepeating && !inputColumnVector2.noNulls && inputColumnVector2.isNull[0];
                        NullUtil.propagateNulls(inputColumnVector1, inputColumnVector2, outputColumnVector, selected, n, batch.selectedInUse);
                        if (!inputColumnVector2.isRepeating || vector2[0] != 0.0 && !inputColumnVector2.isNull[0]) break block13;
                        outputColumnVector.noNulls = false;
                        outputColumnVector.isRepeating = true;
                        outputColumnVector.isNull[0] = true;
                        break block14;
                    }
                    if (!inputColumnVector1.isRepeating || !inputColumnVector1.isNull[0]) break block15;
                    outputColumnVector.noNulls = false;
                    outputColumnVector.isRepeating = true;
                    outputColumnVector.isNull[0] = true;
                    break block14;
                }
                if (!inputColumnVector1.isRepeating || !inputColumnVector2.isRepeating) break block16;
                this.tsUtil.divide(0, vector1[0], vector2[0], outputColumnVector);
                break block14;
            }
            if (!inputColumnVector1.noNulls || !inputColumnVector2.noNulls) break block14;
            if (inputColumnVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = selected[j];
                        this.tsUtil.divide(i, vector1[i], vector2[0], outputColumnVector);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        this.tsUtil.divide(i, vector1[i], vector2[0], outputColumnVector);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    double denominator = vector2[i];
                    if (denominator == 0.0) {
                        outputColumnVector.noNulls = false;
                        outputColumnVector.isNull[i] = true;
                        continue;
                    }
                    this.tsUtil.divide(i, vector1[i], denominator, outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    double denominator = vector2[i];
                    if (denominator == 0.0) {
                        outputColumnVector.noNulls = false;
                        outputColumnVector.isNull[i] = true;
                        continue;
                    }
                    this.tsUtil.divide(i, vector1[i], denominator, outputColumnVector);
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColNum;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("leftColumnNo", this.colNum1);
        trace.attribute("rightColumnNo", this.colNum2);
        trace.attribute("outputColumnNo", this.outputColNum);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColNum = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        super.capture(env, inputNode);
    }
}

