/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorLongScalarDivideLongColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private long value;
    private int columnNo;
    private int outputColumnNo;

    public XVectorLongScalarDivideLongColumn() {
    }

    public XVectorLongScalarDivideLongColumn(long inValue, int inColumnNo, int inOutputColumnNo) {
        this.value = inValue;
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        LongColumnVector inputColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        DoubleColumnVector outputColumnVector = (DoubleColumnVector)batch.columns[this.outputColumnNo];
        if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
            outputColumnVector.setFormatID("Divide", FormatId.INVALID_FORMAT_FID, inputColumnVector.getFormatId());
        }
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        long[] vector = inputColumnVector.vector;
        double[] outputVector = outputColumnVector.vector;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputVector[0] = this.value / vector[0];
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.value / vector[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value / vector[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = this.value / vector[i];
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = this.value / vector[i];
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.value = Long.valueOf(inputNode.attributeValue("value"));
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }
}

