/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import org.dom4j.Element;

public class XVectorStringColumnNotEqualsStringScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private String value;
    private int outputColumnNo;
    private Collator collator;

    public XVectorStringColumnNotEqualsStringScalar(int inColumnNo, String inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        block17: {
            String[] vector;
            boolean[] isNull;
            StringColumnVector inputColumnVector;
            int[] selected;
            int n;
            block15: {
                block16: {
                    super.evaluate(context, batch);
                    n = batch.size;
                    if (n == 0) {
                        return;
                    }
                    this.collator = context.getLocalCollator();
                    selected = batch.selected;
                    inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
                    LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
                    isNull = inputColumnVector.isNull;
                    vector = inputColumnVector.vector;
                    long[] outputVector = outputColumnVector.vector;
                    outputColumnVector.isRepeating = inputColumnVector.isRepeating;
                    if (!inputColumnVector.noNulls) break block15;
                    if (!inputColumnVector.isRepeating) break block16;
                    if (StringUtil.compare(this.collator, vector[0], this.value) == 0) break block17;
                    outputVector[0] = 1L;
                    break block17;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j < n; ++j) {
                        int i = selected[j];
                        outputVector[i] = StringUtil.compare(this.collator, vector[i], this.value) != 0 ? 1L : 0L;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        outputVector[i] = StringUtil.compare(this.collator, vector[i], this.value) != 0 ? 1L : 0L;
                    }
                }
                break block17;
            }
            if (inputColumnVector.isRepeating) {
                outputVector[0] = !isNull[0] ? (StringUtil.compare(this.collator, vector[0], this.value) != 0 ? 1L : 0L) : 0L;
            } else if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (!isNull[i]) {
                        if (StringUtil.compare(this.collator, vector[i], this.value) != 0) {
                            outputVector[i] = 1L;
                            continue;
                        }
                        outputVector[i] = 0L;
                        continue;
                    }
                    outputVector[i] = 0L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!isNull[i]) {
                        if (StringUtil.compare(this.collator, vector[i], this.value) != 0) {
                            outputVector[i] = 1L;
                            continue;
                        }
                        outputVector[i] = 0L;
                        continue;
                    }
                    outputVector[i] = 0L;
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", this.value);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = inputNode.attributeValue("value");
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
    }
}

