/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.numeric;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.util.Random;
import org.dom4j.Element;

public class XVectorRandom
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_OUTPUTCOLUMNNO = "outputColumnNo";
    private static final long DEFAULT_SEED = 12347L;
    private Random random = new Random();
    private int outputColumnNo;

    public XVectorRandom(int inOutputColumnNo) {
        this.outputColumnNo = inOutputColumnNo;
        this.setSeed(12347L);
    }

    protected void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        DoubleColumnVector outputColumnVector = (DoubleColumnVector)batch.columns[this.outputColumnNo];
        outputColumnVector.isRepeating = false;
        outputColumnVector.noNulls = false;
        for (int i = 0; i < outputColumnVector.vector.length; ++i) {
            outputColumnVector.vector[i] = this.random.nextDouble();
            outputColumnVector.isNull[i] = false;
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_OUTPUTCOLUMNNO, this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_OUTPUTCOLUMNNO));
    }
}

