/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.numeric;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class XVectorWidthBucketDecimal
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal ONE = new BigDecimal(1);
    private int columnNo;
    private int outputColumnNo;
    private final BigDecimal min;
    private final BigDecimal max;
    private BigDecimal nBuckets;
    private BigDecimal divisor;
    private boolean minLessThanMax;

    public XVectorWidthBucketDecimal(int inColumnNo, Number inMin, Number inMax, Number inNumBuckets, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
        this.min = new BigDecimal(inMin.longValue());
        this.max = new BigDecimal(inMax.longValue());
        this.nBuckets = new BigDecimal(inNumBuckets.longValue());
        if (this.min.compareTo(this.max) < 0) {
            this.divisor = this.max.subtract(this.min);
            this.minLessThanMax = true;
        } else {
            this.divisor = this.min.subtract(this.max);
            this.minLessThanMax = false;
        }
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        BigDecimal[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            outputVector[0] = this.widthBucket(vector[0]);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.widthBucket(vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.widthBucket(vector[i]);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.widthBucket(vector[i]);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.widthBucket(vector[i]);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    public long widthBucket(BigDecimal operand) {
        if (this.minLessThanMax) {
            if (operand.compareTo(this.min) < 0) {
                return 0L;
            }
            if (operand.compareTo(this.max) >= 0) {
                return this.nBuckets.longValue() + 1L;
            }
            return operand.subtract(this.min).multiply(this.nBuckets).divide(this.divisor).add(ONE).setScale(0, RoundingMode.FLOOR).longValue();
        }
        if (operand.compareTo(this.min) > 0) {
            return 0L;
        }
        if (operand.compareTo(this.max) <= 0) {
            return this.nBuckets.longValue() + 1L;
        }
        return this.min.subtract(operand).multiply(this.nBuckets).divide(this.divisor).add(ONE).setScale(0, RoundingMode.FLOOR).longValue();
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }
}

