/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import org.dom4j.Element;

public class XVectorAggregateMinString
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;

    public XVectorAggregateMinString(int inputColumnNo) {
        super(inputColumnNo);
    }

    public XVectorAggregateMinString() {
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("dataType", this.dataType);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }

    private static final class State
    implements XVectorSetFunction.AggregateState {
        private String minMax;
        private boolean isNull = true;

        private State() {
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputVector, int index) {
            Collator collator = ((StringColumnVector)inputVector).getCollator();
            String value = ((StringColumnVector)inputVector).vector[index];
            if (!inputVector.isNull[index]) {
                if (this.isNull) {
                    this.isNull = false;
                    this.minMax = value;
                } else if (collator != null) {
                    if (collator.compare(value, this.minMax) < 0) {
                        this.minMax = value;
                    }
                } else if (value.compareTo(this.minMax) < 0) {
                    this.minMax = value;
                }
            }
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputVector, int index) {
            Collator collator = ((StringColumnVector)inputVector).getCollator();
            String value = ((StringColumnVector)inputVector).vector[index];
            if (this.isNull) {
                this.isNull = false;
                this.minMax = value;
            } else if (collator != null) {
                if (collator.compare(value, this.minMax) < 0) {
                    this.minMax = value;
                }
            } else if (value.compareTo(this.minMax) < 0) {
                this.minMax = value;
            }
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[targetIndex];
            if (this.isNull) {
                outputColumnVector.setNull(batch.size);
            } else {
                outputColumnVector.vector[batch.size] = this.minMax;
            }
        }

        @Override
        public void reset() {
            this.isNull = true;
        }
    }
}

