/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorAggregateSumDecimal
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;

    public XVectorAggregateSumDecimal(int inputColumnNo) {
        super(inputColumnNo);
    }

    public XVectorAggregateSumDecimal() {
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("dataType", this.dataType);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }

    private static final class State
    implements XVectorSetFunction.AggregateState {
        private BigDecimal sum;
        private int count;
        private int nullCount;
        private boolean isNull = true;

        private State() {
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputVector, int index) {
            BigDecimal value = inputVector.getBigDecimal(index);
            ++this.count;
            if (inputVector.isNull[index]) {
                ++this.nullCount;
                return;
            }
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else {
                this.sum = this.sum.add(value);
            }
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputVector, int index) {
            BigDecimal value = inputVector.getBigDecimal(index);
            ++this.count;
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else {
                this.sum = this.sum.add(value);
            }
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[targetIndex];
            if (this.isNull) {
                outputColumnVector.setNull(batch.size);
            } else {
                outputColumnVector.vector[batch.size] = DecimalUtil.cast(this.sum, outputColumnVector.getDataType());
            }
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = BigDecimal.ZERO;
        }
    }
}

