/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class V5ResultSet
extends XResultSetBase
implements IV5ResultSet {
    public static final String ELEMENT_METADATA = "Metadata";
    public static final String ELEMENT_DIMENSION = "Dimension";
    public static final String ELEMENT_HIERARCHY = "Hierarchy";
    public static final String ELEMENT_LEVEL = "Level";
    public static final String ATTRIBUTE_UNIQUENAME = "uniqueName";
    public static final String ELEMENT_EDGEINFO = "EdgeInfo";
    public static final String ELEMENT_CELLINFO = "CellInfo";
    public static final String ELEMENT_EDGES = "Edges";
    public static final String ELEMENT_EDGE = "Edge";
    public static final String ELEMENT_V5ROWS = "V5Rows";
    public static final String ELEMENT_V5ROW = "V5Row";
    public static final String ELEMENT_CELLDATA = "CellData";
    public static final String ATTRIBUTE_NAME = "name";
    protected IV5ResultSet mBaseV5ResultSet;
    protected V5ResultSet mThisV5ResultSet;
    protected RSAPIEdge[] mEdges;
    private long mNumCells = -1L;
    protected XNode mNode;
    protected boolean mHasMeasureRowset = false;

    public V5ResultSet(XDataContext theDataContext, XNode node, IV5ResultSet v5ResultSet) {
        super(theDataContext, node.getId());
        try {
            this.mThisV5ResultSet = this;
            this.mNode = node;
            this.mBaseV5ResultSet = v5ResultSet;
            RSAPIDataset rsapiDataset = (RSAPIDataset)this.mNode.getAncestorOfType(401005);
            if (rsapiDataset != null) {
                this.mEdges = rsapiDataset.getEdges();
                this.mHasMeasureRowset = rsapiDataset.getCellRowset() != null;
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    public IV5ResultSet getBaseResultSet() {
        return this.mBaseV5ResultSet;
    }

    public long getNumCells() {
        if (this.mNumCells < 0L) {
            if (this.mEdges.length == 0 || !this.mEdges[0].getDataset().isCrossTabReport()) {
                this.mNumCells = 0L;
            } else {
                this.mNumCells = 1L;
                long numEmptyEdges = 0L;
                for (int edgeNum = 0; edgeNum < this.mEdges.length; ++edgeNum) {
                    if (this.mEdges[edgeNum].getHybridResultSetEdgePosition() < 0) {
                        ++numEmptyEdges;
                        continue;
                    }
                    long numRows = this.getV5EdgeSize(this.mEdges[edgeNum]);
                    this.mNumCells *= numRows;
                }
                if (numEmptyEdges == (long)this.mEdges.length) {
                    this.mNumCells = 0L;
                }
            }
        }
        return this.mNumCells;
    }

    public long mapV5CellOrdinal(long thisOrdinal) {
        long baseOrdinal = 0L;
        long baseSize = 1L;
        for (int edgeNum = 0; edgeNum < this.mEdges.length; ++edgeNum) {
            RSAPIEdge edge = this.mEdges[edgeNum];
            long thisEdgeSize = this.mThisV5ResultSet.getV5EdgeSize(edge);
            long baseEdgeSize = this.getBaseResultSet().getV5EdgeSize(edge);
            if (thisEdgeSize > 0L) {
                long thisEdgeOrdinal = thisOrdinal % thisEdgeSize;
                thisOrdinal /= thisEdgeSize;
                long baseEdgeOrdinal = this.mThisV5ResultSet.mapV5EdgeOrdinal(edge, thisEdgeOrdinal);
                baseOrdinal += baseEdgeOrdinal * baseSize;
                baseSize *= baseEdgeSize;
                continue;
            }
            if (this.mHasMeasureRowset) continue;
            return -1L;
        }
        if (thisOrdinal != 0L) {
            return baseSize;
        }
        return baseOrdinal;
    }

    public ICell processV5Cell(ICell cell) {
        return cell;
    }

    public RowValue processV5Row(RSAPIEdge edge, long iRow, RowValue rowValue) {
        return rowValue;
    }

    @Override
    public long getV5EdgeSize(RSAPIEdge edge) {
        return this.getBaseResultSet().getV5EdgeSize(edge);
    }

    public long mapV5EdgeOrdinal(RSAPIEdge edge, long oldOrdinal) {
        return oldOrdinal;
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        return this.getBaseResultSet().getV5EdgeIterator(edge);
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
    }

    @Override
    public XCellIterator getV5CellIterator() {
        return this.getBaseResultSet().getV5CellIterator();
    }

    @Override
    public XScrollableCellIterator getScrollableV5CellIterator() {
        return this.getBaseResultSet().getScrollableV5CellIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toXML(XMLWriter xmlWriter) {
        HashSet<IDimension> dimensionSet = new HashSet<IDimension>();
        if (xmlWriter.isEmpty()) {
            xmlWriter.writeProcessingInstruction("<?xml-stylesheet type=\"text/xsl\" href=\"http://wottcub1:4444/stylesheets/CubeHybridResultSet.xsl\"?>\n");
        }
        xmlWriter.beginElement("V5ResultSet", -1);
        xmlWriter.beginElement(ELEMENT_EDGES, -1);
        for (int i = 0; i < this.mEdges.length; ++i) {
            XIterator edgeIterator = this.getV5EdgeIterator(this.mEdges[i]);
            try {
                xmlWriter.beginElement(ELEMENT_EDGE, -1);
                xmlWriter.attribute(ATTRIBUTE_NAME, ELEMENT_EDGE + i);
                xmlWriter.beginElement(ELEMENT_V5ROWS, -1);
                RowValue v5Row = (RowValue)edgeIterator.next();
                while (v5Row != null) {
                    this.toXML(xmlWriter, v5Row, dimensionSet);
                    v5Row = (RowValue)edgeIterator.next();
                }
            }
            finally {
                edgeIterator.release();
                edgeIterator = null;
            }
            xmlWriter.endElement();
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.beginElement(ELEMENT_CELLDATA, -1);
        XCellIterator cellIterator = this.getV5CellIterator();
        try {
            while (cellIterator.hasNext()) {
                ICell value = cellIterator.next();
                if (value == null) continue;
                value.toXML(xmlWriter);
            }
        }
        finally {
            cellIterator.release();
            cellIterator = null;
        }
        xmlWriter.endElement();
        xmlWriter.beginElement(ELEMENT_METADATA, -1);
        IDimension[] dimArray = new IDimension[dimensionSet.size()];
        dimensionSet.toArray(dimArray);
        Arrays.sort(dimArray, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                IDimension left = (IDimension)arg0;
                IDimension right = (IDimension)arg1;
                return left.getUniqueName().compareTo(right.getUniqueName());
            }
        });
        for (int iDim = 0; iDim < dimArray.length; ++iDim) {
            IDimension dimension = dimArray[iDim];
            xmlWriter.beginElement(ELEMENT_DIMENSION, -1);
            xmlWriter.attribute(ATTRIBUTE_NAME, dimension.getName());
            xmlWriter.attribute(ATTRIBUTE_UNIQUENAME, dimension.getUniqueName());
            List<IHierarchy> hierarchies = dimension.getHierarchies();
            for (int iHier = 0; iHier < hierarchies.size(); ++iHier) {
                IHierarchy hierarchy = hierarchies.get(iHier);
                xmlWriter.beginElement(ELEMENT_HIERARCHY, -1);
                xmlWriter.attribute(ATTRIBUTE_NAME, hierarchy.getName());
                xmlWriter.attribute(ATTRIBUTE_UNIQUENAME, hierarchy.getUniqueName());
                List<ILevel> levels = hierarchy.getLevels();
                for (int iLevel = 0; iLevel < levels.size(); ++iLevel) {
                    ILevel level = levels.get(iLevel);
                    xmlWriter.beginElement(ELEMENT_LEVEL, -1);
                    xmlWriter.attribute(ATTRIBUTE_NAME, level.getName());
                    xmlWriter.attribute(ATTRIBUTE_UNIQUENAME, level.getUniqueName());
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    private void toXML(XMLWriter xmlWriter, RowValue v5Row, Set<IDimension> dimensionSet) {
        xmlWriter.beginElement(ELEMENT_V5ROW, -1);
        for (int idx = 0; idx < v5Row.getNumColumns(); ++idx) {
            ContextBase base;
            base.toXML(xmlWriter);
            for (base = (ContextBase)((Object)v5Row.getColumn(idx)); base != null; base = base.getContextMember()) {
                IMember member;
                IDimension dimension;
                if (!base.contextIsAMember() || dimensionSet.contains(dimension = (member = ((ContextMember)base).getMember()).getDimension())) continue;
                dimensionSet.add(dimension);
            }
        }
        xmlWriter.endElement();
    }

    @Override
    public void releaseImpl() {
        if (this.mBaseV5ResultSet != null) {
            this.mBaseV5ResultSet.release();
            this.mBaseV5ResultSet = null;
        }
    }
}

