/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.v5.V5ResultSet;

public class V5ScrollableMappedCellIterator
extends XScrollableCellIterator {
    private V5ResultSet mThisV5ResultSet;
    private XScrollableCellIterator mBaseCellIterator;
    private long mNumCells;

    public V5ScrollableMappedCellIterator(XDataContext dataContext, V5ResultSet v5ResultSet, XScrollableCellIterator cellIterator, Integer theNodeId) {
        super(dataContext, theNodeId);
        try {
            this.mThisV5ResultSet = v5ResultSet;
            this.mBaseCellIterator = cellIterator;
            this.mNumCells = this.mThisV5ResultSet.getNumCells();
            this.mNumCells = cellIterator != null && cellIterator.hasNext() ? this.mThisV5ResultSet.getNumCells() : 0L;
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentOrdinal < this.mNumCells - 1L;
    }

    @Override
    public ICell nextImpl() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.currentOrdinal;
        ICell cell = this.current();
        if (cell != null) {
            cell = this.mThisV5ResultSet.processV5Cell(cell);
        }
        return cell;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentOrdinal > 0L;
    }

    @Override
    public ICell previous() {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.currentOrdinal;
        ICell cell = this.current();
        return cell;
    }

    @Override
    public ICell current() {
        if (this.currentOrdinal <= -1L || this.currentOrdinal >= this.mNumCells) {
            return null;
        }
        return this.byOrdinal(this.currentOrdinal);
    }

    @Override
    public boolean absolute(long theIndex) {
        if (theIndex <= -1L || theIndex >= this.mNumCells) {
            return false;
        }
        this.currentOrdinal = theIndex;
        return true;
    }

    @Override
    public boolean reset() {
        this.currentOrdinal = -1L;
        return true;
    }

    @Override
    public void release() {
        if (this.mBaseCellIterator != null) {
            this.mBaseCellIterator.release();
            this.mBaseCellIterator = null;
        }
        this.currentOrdinal = -1L;
        this.mNumCells = 0L;
    }

    @Override
    public ICell byOrdinal(long ordinal) {
        if (ordinal <= -1L || ordinal >= this.mNumCells) {
            return null;
        }
        long baseOrdinal = this.mThisV5ResultSet.mapV5CellOrdinal(ordinal);
        ICell cell = this.mBaseCellIterator.byOrdinal(baseOrdinal);
        if (cell != null) {
            cell = this.mThisV5ResultSet.processV5Cell(cell);
            cell.setOrdinal(ordinal);
        } else {
            DoubleValue nullValue = DataValueFactory.createDoubleValue();
            nullValue.setNull();
            cell = new Cell(ordinal, nullValue);
            cell = this.mThisV5ResultSet.processV5Cell(cell);
        }
        return cell;
    }
}

