/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQEPersistCreate;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.ScrollableIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5BuildRowFromAncestor
extends XNode {
    private static final long serialVersionUID = 0L;
    private static final String ELEMENT_SPECS = "specs";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private List<XV5BuildRowFromAncestorSpec> mSpecs = new ArrayList<XV5BuildRowFromAncestorSpec>();

    @Override
    public int getType() {
        return 501142;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        IV5ResultSet sourceResultSet = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        XV5BuildRowFromAncestorResultSet v5Result = new XV5BuildRowFromAncestorResultSet(context, this, sourceResultSet);
        return new V5HybridResultSet(context, v5Result, this.getId());
    }

    public void addXV5Spec(int mEdgeOrdinal, int theAncestorRowsetId, int theRowsetId, List<Integer> theDataItemIndex) {
        XV5BuildRowFromAncestorSpec aSpec = new XV5BuildRowFromAncestorSpec(mEdgeOrdinal, theAncestorRowsetId, theRowsetId, theDataItemIndex);
        this.mSpecs.add(aSpec);
    }

    public boolean isApplicableEdge(int mEdgeOrdinal) {
        for (XV5BuildRowFromAncestorSpec aSpec : this.mSpecs) {
            if (aSpec.getEdgeOrdinal() != mEdgeOrdinal) continue;
            return true;
        }
        return false;
    }

    public IRow processV5Row(int edgeOrdinal, IRow aV5Row) {
        ArrayList<IValue> columns = new ArrayList<IValue>();
        for (int j = 0; j < aV5Row.getNumColumns(); ++j) {
            columns.add(aV5Row.getColumn(j));
        }
        for (XV5BuildRowFromAncestorSpec aSpec : this.mSpecs) {
            if (aSpec.getEdgeOrdinal() != edgeOrdinal) continue;
            int i = 0;
            ContextMember ancestorMember = null;
            while (i < columns.size()) {
                if (columns.get(i) instanceof ContextBase) {
                    ContextBase column = (ContextBase)columns.get(i);
                    RSAPIRowset rowset = column.getRowset();
                    if (rowset == null) continue;
                    if (rowset.getRowsetId() == aSpec.getAncestorRowsetId()) {
                        ancestorMember = (ContextMember)column;
                    }
                    if (rowset.getRowsetId() == aSpec.getRowsetId() && ancestorMember != null) {
                        ContextMember newColumn = null;
                        if (column.getDataItemIndex() == -2) {
                            newColumn = column.contextIsAMember() ? (ContextMember)column : column.getContextMember();
                        } else {
                            newColumn = new ContextMember();
                            columns.add(++i, newColumn);
                        }
                        newColumn.setMember(ancestorMember.getMember());
                        newColumn.setRowset(rowset);
                        newColumn.setDataItemIndex(aSpec.getDataItemIndex().get(0));
                        newColumn.setAdditionalDataItemIndices(aSpec.getDataItemIndex());
                    }
                    if (rowset.getRowsetId() == aSpec.getRowsetId() && ancestorMember == null) {
                        column.setDataItemIndex(aSpec.getDataItemIndex().get(0));
                        ((ContextMember)column).setAdditionalDataItemIndices(aSpec.getDataItemIndex());
                    }
                }
                ++i;
            }
        }
        RowValue updatedRow = DataValueFactory.createRowValue(columns.toArray(new IValue[columns.size()]));
        return updatedRow;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List specsList = inputNode.elements("XV5BuildRowFromAncestorSpec");
        ListIterator it = specsList.listIterator();
        int i = 0;
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            XV5BuildRowFromAncestorSpec aSpec = new XV5BuildRowFromAncestorSpec();
            aSpec.capture(env, anElement);
            this.mSpecs.add(aSpec);
            it.remove();
            ++i;
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5BuildRowFromAncestorSpec aSpec : this.mSpecs) {
            aSpec.dump(trace);
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mSpecs != null) {
            ctx.elementProperty(ELEMENT_SPECS, this.mSpecs);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_SPECS)) {
            Object val = ctx.elementValue(node, new XV5BuildRowFromAncestorCreator());
            this.mSpecs = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XV5BuildRowFromAncestorResultSet
    extends V5ResultSet {
        XV5BuildRowFromAncestorResultSet(XDataContext theDataContext, XNode node, IV5ResultSet v5ResultSet) {
            super(theDataContext, node, v5ResultSet);
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            if (edge != null && ((XV5BuildRowFromAncestor)this.mNode).isApplicableEdge(edge.getOrdinal())) {
                return new V5BuildRowFromAncestorEdgeIterator(this.getDataContext(), (XV5BuildRowFromAncestor)this.mNode, this, edge);
            }
            return this.mBaseV5ResultSet.getV5EdgeIterator(edge);
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            if (edge != null && ((XV5BuildRowFromAncestor)this.mNode).isApplicableEdge(edge.getOrdinal())) {
                return new ScrollableIterator(this.getDataContext(), this.getV5EdgeIterator(edge), this.nodeId, edge);
            }
            return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
        }

        public class V5BuildRowFromAncestorEdgeIterator
        extends XIterator {
            private XV5BuildRowFromAncestor parentXNode;
            private IIterator mIterator;
            private RSAPIEdge mEdge;

            protected void traceRow(IRow aRow) {
                if (this.iteratorTrace == null) {
                    return;
                }
                try {
                    this.iteratorTrace.beginElement("row", -1);
                    if (aRow != null) {
                        for (int j = 0; j < aRow.getNumColumns(); ++j) {
                            if (aRow.getColumn(j) instanceof ContextMember) {
                                ((ContextMember)aRow.getColumn(j)).toXML(this.iteratorTrace);
                                continue;
                            }
                            if (aRow.getColumn(j) instanceof ContextBase) {
                                ((ContextBase)((Object)aRow.getColumn(j))).toXML(this.iteratorTrace);
                                continue;
                            }
                            aRow.getColumn(j).toXML(this.iteratorTrace);
                        }
                    }
                    this.iteratorTrace.endElement();
                    this.iteratorTrace.flush();
                }
                catch (Throwable t) {
                    mErrorLogger.log(t);
                }
            }

            V5BuildRowFromAncestorEdgeIterator(XDataContext theContext, XV5BuildRowFromAncestor theXNode, V5ResultSet theResultSet, RSAPIEdge edge) {
                super(theContext, theXNode.getId());
                this.mEdge = edge;
                this.mIterator = theResultSet.getBaseResultSet().getV5EdgeIterator(edge);
                this.parentXNode = theXNode;
            }

            @Override
            public void release() {
                if (this.mIterator != null) {
                    try {
                        this.mIterator.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.mIterator = null;
                    }
                }
            }

            @Override
            public Object nextImpl() {
                this.openIteratorTrace(this.parentXNode, this.mEdge.getOrdinal(), this.mEdge.getName(), true);
                this.openNextImplTrace(++this.callId);
                IRow srcRow = (IRow)this.mIterator.next();
                if (srcRow == null) {
                    this.closeNextImplTrace();
                    this.closeIteratorTrace();
                    return null;
                }
                IRow outRow = this.parentXNode.processV5Row(this.mEdge.getOrdinal(), srcRow);
                this.traceRow(outRow);
                this.closeNextImplTrace();
                return outRow;
            }
        }
    }

    private final class XV5BuildRowFromAncestorSpec
    implements IXQEPersist {
        private static final String XV5COPY_ANCESTOR_ROW_SPEC = "XV5BuildRowFromAncestorSpec";
        private static final String EDGEORDINAL = "edgeOrdinal";
        private static final String ROWSETID = "rowsetId";
        private static final String ANCESTOR_ROWSETID = "ancestorRowsetId";
        private static final String DATAITEM = "dataItem";
        private static final String INDEX = "index";
        private int mEdgeOrdinal;
        private int mAncestorRowsetId;
        private int mRowsetId;
        private List<Integer> mDataItemIndex;

        XV5BuildRowFromAncestorSpec() {
            this.mEdgeOrdinal = -1;
            this.mAncestorRowsetId = -1;
            this.mRowsetId = -1;
            this.mDataItemIndex = null;
        }

        XV5BuildRowFromAncestorSpec(int theEdgeOrdinal, int theAncestorRowsetId, int theRowsetId, List<Integer> theDataItemIndex) {
            this.mEdgeOrdinal = theEdgeOrdinal;
            this.mAncestorRowsetId = theAncestorRowsetId;
            this.mRowsetId = theRowsetId;
            this.mDataItemIndex = theDataItemIndex;
        }

        public int getEdgeOrdinal() {
            return this.mEdgeOrdinal;
        }

        public int getAncestorRowsetId() {
            return this.mAncestorRowsetId;
        }

        public int getRowsetId() {
            return this.mRowsetId;
        }

        public List<Integer> getDataItemIndex() {
            return this.mDataItemIndex;
        }

        public void dump(XQETrace trace) {
            trace.beginElement(XV5COPY_ANCESTOR_ROW_SPEC, -1);
            trace.attribute(EDGEORDINAL, Integer.toString(this.mEdgeOrdinal));
            trace.attribute(ANCESTOR_ROWSETID, Integer.toString(this.mAncestorRowsetId));
            trace.attribute(ROWSETID, Integer.toString(this.mRowsetId));
            for (int i = 0; i < this.mDataItemIndex.size(); ++i) {
                trace.beginElement(DATAITEM, -1);
                trace.attribute(INDEX, Integer.toString(this.mDataItemIndex.get(i)));
                trace.endElement(-1);
            }
            trace.endElement(-1);
        }

        public void capture(PlanningEnvironment env, Element inputNode) {
            this.mEdgeOrdinal = Integer.parseInt(inputNode.attributeValue(EDGEORDINAL));
            this.mAncestorRowsetId = Integer.parseInt(inputNode.attributeValue(ANCESTOR_ROWSETID));
            this.mRowsetId = Integer.parseInt(inputNode.attributeValue(ROWSETID));
            this.mDataItemIndex = new ArrayList<Integer>();
            List dataItemList = inputNode.elements(DATAITEM);
            ListIterator it = dataItemList.listIterator();
            int i = 0;
            while (it.hasNext()) {
                Element anElement = (Element)it.next();
                this.mDataItemIndex.add(Integer.parseInt(anElement.attributeValue(INDEX)));
                it.remove();
                ++i;
            }
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                this.persistElementProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(EDGEORDINAL, this.mEdgeOrdinal);
            ctx.property(ANCESTOR_ROWSETID, this.mAncestorRowsetId);
            ctx.property(ROWSETID, this.mRowsetId);
        }

        public void persistElementProperties(XQEPersistContext ctx) {
            if (this.mDataItemIndex != null) {
                ctx.elementProperty(DATAITEM, this.mDataItemIndex);
            }
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
            this.restoreChildren(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(EDGEORDINAL)) {
                Object val = ctx.attributeValue(att);
                this.mEdgeOrdinal = (Integer)val;
            } else if (attName.equals(ANCESTOR_ROWSETID)) {
                Object val = ctx.attributeValue(att);
                this.mAncestorRowsetId = (Integer)val;
            } else if (attName.equals(ROWSETID)) {
                Object val = ctx.attributeValue(att);
                this.mRowsetId = (Integer)val;
            }
        }

        protected void restoreChildren(XQERestoreContext ctx, Element node) {
            List childList = node.elements();
            int nChildren = childList.size();
            for (int i = 0; i < nChildren; ++i) {
                Element child = (Element)childList.get(i);
                if (child.getNamespace().getURI().isEmpty()) continue;
                this.restoreElementProperty(ctx, child, node);
            }
        }

        protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
            String pname = node.attributeValue("pname");
            if (pname.equals(DATAITEM)) {
                Object val = ctx.elementValue(node, new XV5BuildRowFromAncestorCreator());
                this.mDataItemIndex = (List)val;
            }
        }
    }

    private class XV5BuildRowFromAncestorCreator
    extends XQEPersistCreate {
        private XV5BuildRowFromAncestorCreator() {
        }

        @Override
        public IXQEPersist create(XQERestoreContext ctx, Element inputNode) {
            IXQEPersist result = null;
            String name = inputNode.getName();
            if (name.equals("XV5BuildRowFromAncestorSpec")) {
                result = new XV5BuildRowFromAncestorSpec();
                result.restore(ctx, inputNode);
            } else {
                result = super.create(ctx, inputNode);
            }
            return result;
        }
    }
}

