/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.XCubeResultSet;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.PushBackIterator;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5MasterDetailWindow
extends XNode {
    private static final long serialVersionUID = 0L;
    public static final String NODE_TYPE_NAME = "XV5MasterDetailWindow";
    private static final String V5_MASTER_DETAIL_WINDOW_SPEC = "V5MasterDetailWindowSpec";
    private static final String MASTERID = "MasterId";
    private static final String DETAILID = "DetailId";
    private static final String COMBINEDID = "CombinedId";
    private static final String MYWINDOWID = "MyWindowId";
    public static final boolean DEBUG = false;
    public static final String HASEXTRAEDGE = "HasExtraEdge";
    private List<XV5MasterDetailWindowSpec> mV5MasterDetailWindowSpecs = new ArrayList<XV5MasterDetailWindowSpec>();
    private static final String PARAMETER_NAME = "parameterName";

    public void addMasterDetailWindowSpec(int idMaster, int idDetail, int idCombined, int id, List<String> paramNames, boolean hasExtraEdge) {
        XV5MasterDetailWindowSpec v5MasterDetailWindowSpec = new XV5MasterDetailWindowSpec(idMaster, idDetail, idCombined, id, paramNames, hasExtraEdge);
        this.mV5MasterDetailWindowSpecs.add(v5MasterDetailWindowSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            CubeHybridResultSet resultSet = null;
            ICubeResultSet cubeResultSet = (ICubeResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
            Iterator<XV5MasterDetailWindowSpec> iterator = this.mV5MasterDetailWindowSpecs.iterator();
            if (iterator.hasNext()) {
                XV5MasterDetailWindowSpec spec = iterator.next();
                if (spec.isMaster()) {
                    XV5MasterDetailWindowMasterResultSet xMasterResultSet = new XV5MasterDetailWindowMasterResultSet(context, cubeResultSet);
                    xMasterResultSet.setAxisNumber(spec.hasExtraEdge());
                    resultSet = new CubeHybridResultSet(context, xMasterResultSet, this.getId(), CacheHints.cacheNone());
                } else {
                    resultSet = new CubeHybridResultSet(context, new XV5MasterDetailWindowDetailResultSet(context, cubeResultSet), this.getId(), CacheHints.cacheCellsAlways());
                }
            }
            iterator = resultSet;
            return iterator;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    @Override
    public int getType() {
        return 501129;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 501129) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List v5MasterDetailWindowSpecsList = CollectionCast.uncheckedCast(inputNode.elements(V5_MASTER_DETAIL_WINDOW_SPEC));
        ListIterator it = v5MasterDetailWindowSpecsList.listIterator();
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            int idMaster = Integer.parseInt(anElement.attributeValue(MASTERID));
            int idDetail = Integer.parseInt(anElement.attributeValue(DETAILID));
            int idCombined = Integer.parseInt(anElement.attributeValue(COMBINEDID));
            int idMyWindow = Integer.parseInt(anElement.attributeValue(MYWINDOWID));
            ArrayList<String> paramNames = new ArrayList<String>();
            paramNames.add(anElement.attributeValue(PARAMETER_NAME));
            boolean hasExtraEdge = Boolean.parseBoolean(anElement.attributeValue(HASEXTRAEDGE));
            this.addMasterDetailWindowSpec(idMaster, idDetail, idCombined, idMyWindow, paramNames, hasExtraEdge);
            it.remove();
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5MasterDetailWindowSpec v5DemoSpec : this.mV5MasterDetailWindowSpecs) {
            trace.beginElement(V5_MASTER_DETAIL_WINDOW_SPEC, -1);
            trace.attribute(MASTERID, Integer.toString(v5DemoSpec.getMasterId()));
            trace.attribute(DETAILID, Integer.toString(v5DemoSpec.getDetailId()));
            trace.attribute(COMBINEDID, Integer.toString(v5DemoSpec.getCombinedId()));
            trace.attribute(MYWINDOWID, Integer.toString(v5DemoSpec.getMyWindowId()));
            trace.attribute(PARAMETER_NAME, v5DemoSpec.getParamNames());
            trace.attribute(HASEXTRAEDGE, Boolean.toString(v5DemoSpec.hasExtraEdge()));
            trace.endElement(-1);
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mV5MasterDetailWindowSpecs != null) {
            ctx.elementProperty(V5_MASTER_DETAIL_WINDOW_SPEC, this.mV5MasterDetailWindowSpecs);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(V5_MASTER_DETAIL_WINDOW_SPEC)) {
            Object val = ctx.elementValue(node);
            this.mV5MasterDetailWindowSpecs = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public static final class XV5MasterDetailWindowSpec
    implements IXQEPersist {
        private int mIdMaster;
        private int mIdDetail;
        private int mIdCombined;
        private int mIdMyWindow;
        private List<String> mParamNames;
        private boolean hasExtraEdge;

        public XV5MasterDetailWindowSpec() {
        }

        protected XV5MasterDetailWindowSpec(int idMaster, int idDetail, int idCombined, int idMyWindow, List<String> paramNames, boolean hasExtraMeasureEdge) {
            this.mIdMaster = idMaster;
            this.mIdDetail = idDetail;
            this.mIdCombined = idCombined;
            this.mIdMyWindow = idMyWindow;
            this.mParamNames = paramNames;
            this.hasExtraEdge = hasExtraMeasureEdge;
        }

        protected int getMasterId() {
            return this.mIdMaster;
        }

        protected int getDetailId() {
            return this.mIdDetail;
        }

        protected int getCombinedId() {
            return this.mIdCombined;
        }

        protected int getMyWindowId() {
            return this.mIdMyWindow;
        }

        protected List<String> getParamNames() {
            return this.mParamNames;
        }

        public boolean isMaster() {
            return this.mIdMyWindow == this.mIdMaster;
        }

        public boolean isDetail() {
            return this.mIdMyWindow == this.mIdDetail;
        }

        protected boolean hasExtraEdge() {
            return this.hasExtraEdge;
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                this.persistElementProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(XV5MasterDetailWindow.MASTERID, this.mIdMaster);
            ctx.property(XV5MasterDetailWindow.DETAILID, this.mIdDetail);
            ctx.property(XV5MasterDetailWindow.COMBINEDID, this.mIdCombined);
            ctx.property(XV5MasterDetailWindow.MYWINDOWID, this.mIdMyWindow);
            ctx.property(XV5MasterDetailWindow.HASEXTRAEDGE, this.hasExtraEdge);
        }

        public void persistElementProperties(XQEPersistContext ctx) {
            if (this.mParamNames != null) {
                ctx.elementProperty(XV5MasterDetailWindow.PARAMETER_NAME, this.mParamNames);
            }
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
            this.restoreChildren(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(XV5MasterDetailWindow.MASTERID)) {
                Object val = ctx.attributeValue(att);
                this.mIdMaster = (Integer)val;
            } else if (attName.equals(XV5MasterDetailWindow.DETAILID)) {
                Object val = ctx.attributeValue(att);
                this.mIdDetail = (Integer)val;
            } else if (attName.equals(XV5MasterDetailWindow.COMBINEDID)) {
                Object val = ctx.attributeValue(att);
                this.mIdCombined = (Integer)val;
            } else if (attName.equals(XV5MasterDetailWindow.MYWINDOWID)) {
                Object val = ctx.attributeValue(att);
                this.mIdMyWindow = (Integer)val;
            } else if (attName.equals(XV5MasterDetailWindow.HASEXTRAEDGE)) {
                Object val = ctx.attributeValue(att);
                this.hasExtraEdge = (Boolean)val;
            }
        }

        protected void restoreChildren(XQERestoreContext ctx, Element node) {
            List childList = node.elements();
            int nChildren = childList.size();
            for (int i = 0; i < nChildren; ++i) {
                Element child = (Element)childList.get(i);
                if (child.getNamespace().getURI().isEmpty()) continue;
                this.restoreElementProperty(ctx, child, node);
            }
        }

        protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
            String pname = node.attributeValue("pname");
            if (pname.equals(XV5MasterDetailWindow.PARAMETER_NAME)) {
                Object val = ctx.elementValue(node);
                this.mParamNames = (List)val;
            }
        }
    }

    private class XV5MasterDetailWindowDetailResultSet
    extends XCubeResultSet {
        private int numAxes;
        int[] edgeSizes;
        private XMappingView mMappingView;
        private int edgeNumToRemove;

        XV5MasterDetailWindowDetailResultSet(XDataContext context, ICubeResultSet sourceResult) {
            super(context, sourceResult, XV5MasterDetailWindow.this.getId());
            this.numAxes = -1;
            List<String> parameterNames = null;
            ArrayList<V5ParameterValueItem> parameterValues = new ArrayList<V5ParameterValueItem>();
            if (XV5MasterDetailWindow.this.mV5MasterDetailWindowSpecs.size() != 1) {
                XV5MasterDetailWindow.this.throwInternalError("Expecting to get exactly 1 specification for this XNode");
            }
            XV5MasterDetailWindowSpec spec = (XV5MasterDetailWindowSpec)XV5MasterDetailWindow.this.mV5MasterDetailWindowSpecs.get(0);
            parameterNames = spec.getParamNames();
            this.edgeNumToRemove = this.getBaseResultSet().getNumAxes() - 1;
            IDataType dt = null;
            for (String parameterName : parameterNames) {
                Parameter parameter = context.getParameter(parameterName);
                if (parameter == null || !parameter.isResolved()) continue;
                V5ParameterValueItem itemValue = (V5ParameterValueItem)parameter.getParameterValueItems().get(0);
                parameterValues.add(itemValue);
                dt = parameter.getDataType();
            }
            try {
                this.initialize(sourceResult);
                this.computeNumOfCells(parameterValues, dt);
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        private void initialize(ICubeResultSet sourceResultSet) {
            this.numAxes = this.getBaseResultSet().getNumAxes() - 1;
            this.edgeSizes = new int[this.numAxes + 1];
            for (int edgeNum = 0; edgeNum < this.numAxes + 1; ++edgeNum) {
                this.edgeSizes[edgeNum] = (int)this.getBaseResultSet().getAxisSize(edgeNum);
            }
            if (this.mMappingView == null) {
                this.mMappingView = new XMappingView();
            }
        }

        public long mapV5CellOrdinal() {
            return this.mMappingView.mOrdinalMasterEdge * this.mMappingView.mUpdatedNumCells;
        }

        private void computeNumOfCells(List<V5ParameterValueItem> parameterValues, IDataType dt) {
            this.mMappingView.computeUpdatedNumOfCells(parameterValues, dt);
        }

        @Override
        public XCellIterator getCellIterator() {
            return new XCellMappingCellIterator(this, this.nodeId);
        }

        @Override
        public XScrollableCellIterator getScrollableCellIterator() {
            return new XScrollableCellMappingCellIterator(this, this.nodeId);
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            if (this.numAxes <= 0 || axisNumber < 0 || axisNumber >= this.numAxes) {
                throw new IllegalStateException();
            }
            return new XAxisMappingAxisIterator(this.getDataContext(), axisNumber, this.nodeId);
        }

        @Override
        public long getAxisSize(int axisNumber) {
            if (this.numAxes <= 0 || axisNumber < 0 || axisNumber >= this.numAxes) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getAxisSize(axisNumber);
        }

        @Override
        public int getNumAxes() {
            return this.numAxes;
        }

        private final class XAxisMappingAxisIterator
        extends XIterator {
            protected int mNumRows;
            XIterator columnIter;
            protected boolean eod;

            private XAxisMappingAxisIterator(XDataContext context, int axisNum, Integer theNodeId) {
                super(context, theNodeId);
                this.eod = false;
                this.mNumRows = (int)XV5MasterDetailWindowDetailResultSet.this.getBaseResultSet().getAxisSize(axisNum);
                this.columnIter = XV5MasterDetailWindowDetailResultSet.this.getBaseResultSet().getAxisIterator(axisNum);
                if (this.mNumRows > 0) {
                    this.eod = false;
                }
            }

            @Override
            public Object nextImpl() {
                if (this.eod) {
                    return null;
                }
                if (this.currentIndex + 1L < (long)this.mNumRows) {
                    ++this.currentIndex;
                    return this.columnIter.next();
                }
                this.currentIndex = -1L;
                this.eod = true;
                return null;
            }

            @Override
            public void release() {
                this.mNumRows = 0;
                if (this.columnIter != null) {
                    this.columnIter.release();
                }
            }
        }

        private final class XCellMappingCellIterator
        extends XCellIterator {
            XV5MasterDetailWindowDetailResultSet mOwnerResultSet;
            PushBackIterator mBaseCellIter;
            protected long baseStartOrdinal;
            protected boolean eod;

            private XCellMappingCellIterator(XV5MasterDetailWindowDetailResultSet owner, Integer theNodeId) {
                super(owner.getDataContext(), theNodeId);
                this.baseStartOrdinal = -1L;
                this.eod = false;
                this.mOwnerResultSet = owner;
                this.mBaseCellIter = new PushBackIterator(XV5MasterDetailWindowDetailResultSet.this.getBaseResultSet().getCellIterator());
                this.baseStartOrdinal = this.mOwnerResultSet.mapV5CellOrdinal();
                this.positionBaseCellIterator();
                if (((XV5MasterDetailWindowDetailResultSet)owner).mMappingView.mUpdatedNumCells == 0) {
                    this.eod = true;
                }
            }

            private void positionBaseCellIterator() {
                while (!this.eod && this.mBaseCellIter.getIndex() < this.baseStartOrdinal - 1L) {
                    ICell cell = this.mBaseCellIter.next();
                    if (cell != null) continue;
                    this.eod = true;
                }
                if (this.mBaseCellIter.getIndex() >= this.baseStartOrdinal) {
                    this.mBaseCellIter.pushBack();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.eod) {
                    return false;
                }
                if (!this.mBaseCellIter.hasNext()) {
                    this.eod = true;
                    return false;
                }
                ICell cell = this.mBaseCellIter.next();
                if (cell == null) {
                    this.eod = true;
                    return false;
                }
                this.mBaseCellIter.pushBack();
                return cell.getOrdinal() < this.baseStartOrdinal + (long)((XV5MasterDetailWindowDetailResultSet)this.mOwnerResultSet).mMappingView.mUpdatedNumCells;
            }

            @Override
            public void release() {
                this.mBaseCellIter.release();
                this.eod = true;
            }

            @Override
            public long getIndex() {
                return this.mBaseCellIter.getIndex() - this.baseStartOrdinal;
            }

            @Override
            public ICell nextImpl() {
                if (!this.mBaseCellIter.hasNext()) {
                    this.eod = true;
                    return null;
                }
                ICell cell = this.mBaseCellIter.next();
                if (cell == null) {
                    this.eod = true;
                    return null;
                }
                if (cell.getOrdinal() >= this.baseStartOrdinal + (long)((XV5MasterDetailWindowDetailResultSet)this.mOwnerResultSet).mMappingView.mUpdatedNumCells) {
                    this.mBaseCellIter.pushBack();
                    return null;
                }
                long origOrdinal = cell.getOrdinal();
                if (this.baseStartOrdinal > 0L) {
                    cell.setOrdinal(origOrdinal - this.baseStartOrdinal);
                }
                return cell;
            }

            @Override
            public boolean hasPipelineIterator() {
                return false;
            }
        }

        private final class XScrollableCellMappingCellIterator
        extends XScrollableCellIterator {
            protected long baseStartOrdinal;
            private XScrollableCellIterator sourceCellIterator;
            private boolean empty;

            private XScrollableCellMappingCellIterator(XV5MasterDetailWindowDetailResultSet owner, Integer theNodeId) {
                super(owner.getDataContext(), theNodeId);
                this.baseStartOrdinal = -1L;
                this.empty = false;
                this.baseStartOrdinal = owner.mapV5CellOrdinal();
                if (((XV5MasterDetailWindowDetailResultSet)owner).mMappingView.mUpdatedNumCells == 0 || this.baseStartOrdinal < 0L) {
                    this.empty = true;
                } else {
                    this.sourceCellIterator = XV5MasterDetailWindowDetailResultSet.this.getBaseResultSet().getScrollableCellIterator();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.empty) {
                    return false;
                }
                return this.sourceCellIterator.hasNext();
            }

            @Override
            public ICell byOrdinal(long ordinal) {
                if (this.empty || ordinal < 0L) {
                    return null;
                }
                return this.sourceCellIterator.byOrdinal(ordinal + this.baseStartOrdinal);
            }

            @Override
            public boolean absolute(long index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICell current() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasPrevious() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICell previous() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean reset() {
                return true;
            }

            @Override
            public ICell nextImpl() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void release() {
                if (this.sourceCellIterator != null) {
                    this.sourceCellIterator.release();
                }
            }
        }

        private final class XMappingView {
            private int mOrdinalMasterEdge = -1;
            protected int mUpdatedNumCells;

            private XMappingView() {
            }

            private void computeUpdatedNumOfCells(List<V5ParameterValueItem> parameterValues, IDataType dt) {
                XV5MasterDetailWindowSpec suppressSpecColumnAxe = null;
                boolean bCaption = false;
                Iterator iterator = XV5MasterDetailWindow.this.mV5MasterDetailWindowSpecs.iterator();
                while (iterator.hasNext()) {
                    XV5MasterDetailWindowSpec spec;
                    suppressSpecColumnAxe = spec = (XV5MasterDetailWindowSpec)iterator.next();
                    if (spec.mIdMaster != -1 && (dt == null || !(dt instanceof MemberCaptionType))) continue;
                    bCaption = true;
                }
                this.getMasterEdgeOrd(suppressSpecColumnAxe, parameterValues, bCaption);
                int sm = 1;
                for (int i = 0; i < XV5MasterDetailWindowDetailResultSet.this.numAxes; ++i) {
                    sm *= (int)XV5MasterDetailWindowDetailResultSet.this.getBaseResultSet().getAxisSize(i);
                }
                this.mUpdatedNumCells = sm;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void getMasterEdgeOrd(XV5MasterDetailWindowSpec suppressSpec, List<V5ParameterValueItem> parameterValues, boolean bCaption) {
                if (suppressSpec == null) {
                    return;
                }
                ICubeResultSet baseResult = XV5MasterDetailWindowDetailResultSet.this.getBaseResultSet();
                long axisSize = baseResult.getAxisSize(XV5MasterDetailWindowDetailResultSet.this.edgeNumToRemove);
                if (axisSize == 0L) {
                    return;
                }
                XIterator columnIter = baseResult.getAxisIterator(XV5MasterDetailWindowDetailResultSet.this.edgeNumToRemove);
                try {
                    while (columnIter.getIndex() + 1L < axisSize) {
                        ITuple memberTup = (ITuple)columnIter.next();
                        if (!this.doesTupleMatchParameters(memberTup, parameterValues, bCaption)) continue;
                        this.mOrdinalMasterEdge = (int)columnIter.getIndex();
                        break;
                    }
                }
                finally {
                    columnIter.release();
                }
            }

            private boolean doesTupleMatchParameters(ITuple memberTup, List<V5ParameterValueItem> parameterValues, boolean bCaption) {
                if (memberTup.size() != parameterValues.size()) {
                    return false;
                }
                boolean foundTuple = true;
                String memberValue = null;
                String parameterValue = null;
                int i = 0;
                for (IMember member : memberTup.getMembers()) {
                    if (bCaption) {
                        memberValue = member.getCaption();
                        parameterValue = parameterValues.get(i).getExternalValue();
                    } else if (member.isContextMember() && ((ContextMember)member).getMember().isDMR()) {
                        memberValue = ((ContextMember)member).getMember().getV5UniqueName();
                        parameterValue = parameterValues.get(i).getInternalValue();
                    } else {
                        memberValue = member.getUniqueName();
                        parameterValue = parameterValues.get(i).getExternalValue();
                    }
                    if (memberValue == null) {
                        if (parameterValues.get(i) == null) break;
                        foundTuple = false;
                        break;
                    }
                    if (!memberValue.equals(parameterValue)) {
                        foundTuple = false;
                        break;
                    }
                    ++i;
                }
                return foundTuple;
            }
        }
    }

    private class XV5MasterDetailWindowMasterResultSet
    extends XCubeResultSet {
        private int numAxes;
        private int masterAxisNumber;

        XV5MasterDetailWindowMasterResultSet(XDataContext context, ICubeResultSet sourceResult) {
            super(context, sourceResult, XV5MasterDetailWindow.this.getId());
            this.numAxes = -1;
            this.numAxes = 1;
            this.masterAxisNumber = -1;
            XQEDebugLog.out.printf("executing XV5MasterDetailWindowMasterResultSet id: %d\n", XV5MasterDetailWindow.this.getId());
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            if (axisNumber != 0) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getAxisIterator(this.masterAxisNumber);
        }

        @Override
        public long getAxisSize(int axisNumber) {
            if (axisNumber != 0) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getAxisSize(this.masterAxisNumber);
        }

        @Override
        public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
            if (axisNumber != 0) {
                throw new IllegalStateException();
            }
            return this.getBaseResultSet().getScrollableAxisIterator(this.masterAxisNumber);
        }

        @Override
        public int getNumAxes() {
            return this.numAxes;
        }

        public void setAxisNumber(boolean hasExtraEdge) {
            this.masterAxisNumber = hasExtraEdge ? this.getBaseResultSet().getNumAxes() - 2 : this.getBaseResultSet().getNumAxes() - 1;
        }
    }
}

