/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5PositionRow
extends XNode {
    private static final long serialVersionUID = 0L;
    public static final String NODE_TYPE_NAME = "XV5PositionRow";
    private static final String XV5POSITIONROWRULE = "XV5PositionRowRule";
    private static final String EDGENUM = "EdgeNum";
    private static final String ROWSETID = "RowsetId";
    private static final String DATAITEMINDEX = "DataItemIndex";
    private static final String SOURCEVALUE = "SourceValue";
    private static final String TARGETVALUE = "TargetValue";
    private static final String ORIGINALTARGETVALUE = "OriginalTargetValue";
    private static final String POSITIONBEFORE = "PositionBefore";
    private List<XV5PositionRowRule> mPositionRowRuleList = new ArrayList<XV5PositionRowRule>();

    @Override
    protected IValue executeImpl(XDataContext context) {
        IV5ResultSet sourceResult = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        XV5PositionRowResultSet v5Result = new XV5PositionRowResultSet(context, this, sourceResult);
        return new V5HybridResultSet(context, v5Result, this.getId());
    }

    @Override
    public int getType() {
        return 501081;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == this.getType()) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List aPositionRowRuleList = inputNode.elements(XV5POSITIONROWRULE);
        ListIterator itRule = aPositionRowRuleList.listIterator();
        while (itRule.hasNext()) {
            Element ruleElement = (Element)itRule.next();
            int edgeNum = Integer.parseInt(ruleElement.attributeValue(EDGENUM));
            int rowsetId = Integer.parseInt(ruleElement.attributeValue(ROWSETID));
            int dataItemIndex = Integer.parseInt(ruleElement.attributeValue(DATAITEMINDEX));
            String sourceValue = String.valueOf(ruleElement.attribute(SOURCEVALUE));
            String targetValue = String.valueOf(ruleElement.attribute(TARGETVALUE));
            boolean positionBefore = Boolean.parseBoolean(ruleElement.attributeValue(POSITIONBEFORE));
            XV5PositionRowRule rule = new XV5PositionRowRule(edgeNum, rowsetId, dataItemIndex, sourceValue, targetValue, positionBefore);
            this.addPositionRowRule(rule);
            itRule.remove();
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5PositionRowRule aRule : this.mPositionRowRuleList) {
            trace.beginElement(XV5POSITIONROWRULE, -1);
            trace.attribute(EDGENUM, Integer.toString(aRule.getEdgeNum()));
            trace.attribute(ROWSETID, Integer.toString(aRule.getRowsetId()));
            trace.attribute(DATAITEMINDEX, Integer.toString(aRule.getDataItemIndex()));
            trace.attribute(SOURCEVALUE, aRule.getSourceValue());
            trace.attribute(TARGETVALUE, aRule.getTargetValue());
            trace.attribute(POSITIONBEFORE, Boolean.toString(aRule.getPositionBefore()));
            trace.endElement(-1);
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement(this.getNodeTypeName(), -1);
        this.dumpExtraInfo(trace, true);
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement(-1);
    }

    public void addPositionRowRule(XV5PositionRowRule rule) {
        this.mPositionRowRuleList.add(rule);
    }

    public void addPositionRowRule(List<XV5PositionRowRule> rules) {
        this.mPositionRowRuleList.addAll(rules);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mPositionRowRuleList != null) {
            ctx.elementProperty(XV5POSITIONROWRULE, this.mPositionRowRuleList);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(XV5POSITIONROWRULE)) {
            Object val = ctx.elementValue(node);
            this.mPositionRowRuleList = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public static final class XV5PositionRowRule
    implements IXQEPersist {
        private int mEdgeNum;
        private int mRowsetId;
        private int mDataItemIndex;
        private String mSourceValue;
        private String mTargetValue;
        private String mOriginalTargetValue;
        private boolean mPositionBefore;

        public XV5PositionRowRule() {
        }

        public XV5PositionRowRule(int theEdgeNum, int theRowsetId, int theDataItemIndex, String theSourceValue, String theTargetValue, boolean thePositionBefore) {
            this.mEdgeNum = theEdgeNum;
            this.mRowsetId = theRowsetId;
            this.mDataItemIndex = theDataItemIndex;
            this.mSourceValue = theSourceValue;
            this.mTargetValue = theTargetValue;
            this.mOriginalTargetValue = theTargetValue;
            this.mPositionBefore = thePositionBefore;
        }

        public int getEdgeNum() {
            return this.mEdgeNum;
        }

        public int getRowsetId() {
            return this.mRowsetId;
        }

        public int getDataItemIndex() {
            return this.mDataItemIndex;
        }

        public String getSourceValue() {
            return this.mSourceValue;
        }

        public String getTargetValue() {
            return this.mTargetValue;
        }

        public void setTargetValue(String theTargetValue) {
            this.mTargetValue = theTargetValue;
        }

        public String getOriginalTargetValue() {
            return this.mOriginalTargetValue;
        }

        public boolean getPositionBefore() {
            return this.mPositionBefore;
        }

        public boolean hasSameTarget(XV5PositionRowRule rule) {
            return this.getEdgeNum() == rule.getEdgeNum() && this.getRowsetId() == rule.getRowsetId() && this.getDataItemIndex() == rule.getDataItemIndex() && this.getOriginalTargetValue().equals(rule.getTargetValue()) && this.getPositionBefore() == rule.getPositionBefore();
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(XV5PositionRow.EDGENUM, this.mEdgeNum);
            ctx.property(XV5PositionRow.ROWSETID, this.mRowsetId);
            ctx.property(XV5PositionRow.DATAITEMINDEX, this.mDataItemIndex);
            ctx.property(XV5PositionRow.SOURCEVALUE, this.mSourceValue);
            ctx.property(XV5PositionRow.TARGETVALUE, this.mTargetValue);
            ctx.property(XV5PositionRow.ORIGINALTARGETVALUE, this.mOriginalTargetValue);
            ctx.property(XV5PositionRow.POSITIONBEFORE, this.mPositionBefore);
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(XV5PositionRow.EDGENUM)) {
                Object val = ctx.attributeValue(att);
                this.mEdgeNum = (Integer)val;
            } else if (attName.equals(XV5PositionRow.ROWSETID)) {
                Object val = ctx.attributeValue(att);
                this.mRowsetId = (Integer)val;
            } else if (attName.equals(XV5PositionRow.DATAITEMINDEX)) {
                Object val = ctx.attributeValue(att);
                this.mDataItemIndex = (Integer)val;
            } else if (attName.equals(XV5PositionRow.SOURCEVALUE)) {
                Object val = ctx.attributeValue(att);
                this.mSourceValue = (String)val;
            } else if (attName.equals(XV5PositionRow.TARGETVALUE)) {
                Object val = ctx.attributeValue(att);
                this.mTargetValue = (String)val;
            } else if (attName.equals(XV5PositionRow.ORIGINALTARGETVALUE)) {
                Object val = ctx.attributeValue(att);
                this.mOriginalTargetValue = (String)val;
            } else if (attName.equals(XV5PositionRow.POSITIONBEFORE)) {
                Object val = ctx.attributeValue(att);
                this.mPositionBefore = (Boolean)val;
            }
        }
    }

    private class XV5PositionRowResultSet
    extends V5ResultSet {
        private XV5PositionRowEdge[] mPositionRowEdges;

        XV5PositionRowResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
            super(context, node, sourceResult);
            try {
                int numEdges = this.mEdges.length;
                this.mPositionRowEdges = new XV5PositionRowEdge[numEdges];
                for (XV5PositionRowRule positionRule : XV5PositionRow.this.mPositionRowRuleList) {
                    int edgeNum = positionRule.getEdgeNum();
                    if (this.mPositionRowEdges[edgeNum] != null) continue;
                    this.mPositionRowEdges[edgeNum] = new XV5PositionRowEdge(this.mEdges[edgeNum]);
                    this.mPositionRowEdges[edgeNum].doReposition();
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public long mapV5EdgeOrdinal(RSAPIEdge edge, long oldOrdinal) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mPositionRowEdges[edgeNum] == null) {
                return oldOrdinal;
            }
            return this.mPositionRowEdges[edgeNum].mapIndex(oldOrdinal);
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mPositionRowEdges[edgeNum] == null) {
                return this.getBaseResultSet().getV5EdgeIterator(edge);
            }
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5PositionRow.this.getId());
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mPositionRowEdges[edgeNum] == null) {
                return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
            }
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5PositionRow.this.getId());
        }

        @Override
        public XCellIterator getV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5PositionRow.this.getId());
        }

        @Override
        public XScrollableCellIterator getScrollableV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5PositionRow.this.getId());
        }

        @Override
        public void releaseImpl() {
            if (this.mPositionRowEdges != null) {
                for (int i = 0; i < this.mPositionRowEdges.length; ++i) {
                    if (this.mPositionRowEdges[i] == null) continue;
                    this.mPositionRowEdges[i].release();
                    this.mPositionRowEdges[i] = null;
                }
                this.mPositionRowEdges = null;
            }
            super.releaseImpl();
        }

        private final class XV5PositionRowEdge {
            protected RSAPIEdge mEdge;
            private Long[] mOrder;
            private IScrollableIterator mBaseIterator;

            public long mapIndex(long index) {
                if (index >= (long)this.mOrder.length) {
                    return index;
                }
                return this.mOrder[(int)index];
            }

            XV5PositionRowEdge(RSAPIEdge edge) {
                this.mEdge = edge;
                this.mBaseIterator = XV5PositionRowResultSet.this.getBaseResultSet().getScrollableV5EdgeIterator(this.mEdge);
            }

            public void doReposition() {
                long numRows = XV5PositionRowResultSet.this.getBaseResultSet().getV5EdgeSize(this.mEdge);
                this.mOrder = new Long[(int)numRows];
                for (int i = 0; i < (int)numRows; ++i) {
                    this.mOrder[i] = new Long(i);
                }
                for (int inx = 0; inx < XV5PositionRow.this.mPositionRowRuleList.size(); ++inx) {
                    XV5PositionRowRule positionRowRule = (XV5PositionRowRule)XV5PositionRow.this.mPositionRowRuleList.get(inx);
                    if (positionRowRule.getEdgeNum() != this.mEdge.getPositionalOrdinal()) continue;
                    XV5PositionRowApply positionRowApply = new XV5PositionRowApply(positionRowRule);
                    long start = 0L;
                    while (start < (long)this.mOrder.length) {
                        start = positionRowApply.repositionSubset(start);
                    }
                }
            }

            public void release() {
                if (this.mBaseIterator != null) {
                    this.mBaseIterator.release();
                    this.mBaseIterator = null;
                }
            }

            private final class XV5PositionRowApply {
                XV5PositionRowRule mPositionRowRule = null;
                private RSAPIEdgeRowset[] mCurrRowsets = null;

                XV5PositionRowApply(XV5PositionRowRule thePositionRowRule) {
                    this.mPositionRowRule = thePositionRowRule;
                    ArrayList<RSAPIEdgeRowset> myRowsets = new ArrayList<RSAPIEdgeRowset>();
                    for (int inx = 0; inx < XV5PositionRowEdge.this.mEdge.getNumRowsets(); ++inx) {
                        RSAPIEdgeRowset rowset = XV5PositionRowEdge.this.mEdge.getRowset(inx);
                        if (rowset.getRowsetId() != this.mPositionRowRule.getRowsetId()) continue;
                        while (rowset != null) {
                            myRowsets.add(rowset);
                            rowset = rowset.getParentRowset();
                        }
                        break;
                    }
                    Collections.reverse(myRowsets);
                    this.mCurrRowsets = myRowsets.toArray(new RSAPIEdgeRowset[myRowsets.size()]);
                }

                public long repositionSubset(long start) {
                    RowValue currRow = null;
                    while (start < (long)XV5PositionRowEdge.this.mOrder.length && (currRow = this.loadRow(start)) == null) {
                        ++start;
                    }
                    if (start >= (long)XV5PositionRowEdge.this.mOrder.length) {
                        return start;
                    }
                    ArrayList<XV5PositionRowOrdinal> aList = new ArrayList<XV5PositionRowOrdinal>();
                    long first = start;
                    for (long curr = start + 1L; curr <= (long)XV5PositionRowEdge.this.mOrder.length; ++curr) {
                        RowValue lastRow = (RowValue)currRow.copy();
                        if (curr < (long)XV5PositionRowEdge.this.mOrder.length) {
                            currRow = this.loadRow(curr);
                            if (currRow != null && this.isBreakRow(currRow, lastRow)) {
                                currRow = null;
                            }
                            if (currRow != null && this.compareMember(this.getKey(currRow), this.getKey(lastRow))) continue;
                        }
                        aList.add(new XV5PositionRowOrdinal(start, curr - start, this.getKey(lastRow)));
                        start = curr;
                        if (curr >= (long)XV5PositionRowEdge.this.mOrder.length || currRow == null) break;
                    }
                    if (aList.size() > 1) {
                        this.repositionOrdinals(aList);
                        this.updateOrder(aList, first, start);
                    }
                    return start;
                }

                private void repositionOrdinals(ArrayList<XV5PositionRowOrdinal> aList) {
                    for (int sourceIdx = 0; sourceIdx < aList.size(); ++sourceIdx) {
                        int insertIdx;
                        XV5PositionRowOrdinal targetOrdinal;
                        ContextMember targetMember;
                        String targetValue;
                        int targetIdx;
                        XV5PositionRowOrdinal sourceOrdinal = aList.get(sourceIdx);
                        ContextMember sourceMember = (ContextMember)sourceOrdinal.getKey();
                        String sourceValue = sourceMember.getV5UniqueName();
                        if (!sourceValue.equals(this.mPositionRowRule.getSourceValue())) continue;
                        for (targetIdx = 0; !(targetIdx >= aList.size() || targetIdx != sourceIdx && (targetValue = (targetMember = (ContextMember)(targetOrdinal = aList.get(targetIdx)).getKey()).getCognosUniqueNameNormalized()).equals(this.mPositionRowRule.getTargetValue())); ++targetIdx) {
                        }
                        if (sourceIdx < targetIdx) {
                            insertIdx = targetIdx - 1;
                            if (targetIdx < aList.size() && !this.mPositionRowRule.getPositionBefore()) {
                                ++insertIdx;
                            }
                            for (int shiftIdx = sourceIdx + 1; shiftIdx <= insertIdx; ++shiftIdx) {
                                aList.set(shiftIdx - 1, aList.get(shiftIdx));
                            }
                        } else {
                            insertIdx = targetIdx;
                            if (targetIdx < aList.size() && !this.mPositionRowRule.getPositionBefore()) {
                                ++insertIdx;
                            }
                            for (int shiftIdx = sourceIdx; shiftIdx > insertIdx; --shiftIdx) {
                                aList.set(shiftIdx, aList.get(shiftIdx - 1));
                            }
                        }
                        aList.set(insertIdx, sourceOrdinal);
                        break;
                    }
                }

                private RowValue loadRow(long index) {
                    XV5PositionRowEdge.this.mBaseIterator.absolute(XV5PositionRowEdge.this.mapIndex(index));
                    RowValue row = (RowValue)XV5PositionRowEdge.this.mBaseIterator.current();
                    int numColumns = row.getNumColumns();
                    for (int inx = 0; inx < this.mCurrRowsets.length && numColumns > inx; ++inx) {
                        ContextBase col = (ContextBase)((Object)row.getColumn(inx));
                        if (col.getRowset() == null || col.getRowset().getRowsetId() == this.mCurrRowsets[inx].getRowsetId()) continue;
                        return null;
                    }
                    return row;
                }

                private ContextBase getKey(RowValue row) {
                    ContextBase col = null;
                    for (int inx = this.mCurrRowsets.length - 1; inx < row.getNumColumns() && ((col = (ContextBase)((Object)row.getColumn(inx))).getRowset() == null || col.getRowset().getRowsetId() != this.mPositionRowRule.getRowsetId() || col.getDataItemIndex() != this.mPositionRowRule.getDataItemIndex()); ++inx) {
                    }
                    return col;
                }

                private boolean isBreakRow(RowValue currRow, RowValue lastRow) {
                    for (int inx = 0; inx < this.mCurrRowsets.length - 1; ++inx) {
                        if (this.compareMember((ContextBase)((Object)currRow.getColumn(inx)), (ContextBase)((Object)lastRow.getColumn(inx)))) continue;
                        return true;
                    }
                    return false;
                }

                private boolean compareMember(ContextBase currCol, ContextBase lastCol) {
                    if (currCol.contextIsAMember() && lastCol.contextIsAMember()) {
                        IMember iMemb1 = ((ContextMember)currCol).getMember();
                        IMember iMemb2 = ((ContextMember)lastCol).getMember();
                        if (iMemb1 == null && iMemb2 == null) {
                            return true;
                        }
                        if (iMemb1 == null || iMemb2 == null) {
                            return false;
                        }
                        return iMemb1.getUniqueName().equals(iMemb2.getUniqueName());
                    }
                    if (currCol.contextIsAValue() && lastCol.contextIsAValue()) {
                        ContextValue val1 = (ContextValue)currCol;
                        ContextValue val2 = (ContextValue)lastCol;
                        return val1.compareTo(val2) == 0;
                    }
                    return false;
                }

                private void updateOrder(ArrayList<XV5PositionRowOrdinal> aList, long start, long last) {
                    long size = last - start;
                    long origin = start;
                    Long[] orderCopy = new Long[(int)size];
                    System.arraycopy(XV5PositionRowEdge.this.mOrder, (int)start, orderCopy, 0, (int)size);
                    for (int i = 0; i < aList.size(); ++i) {
                        XV5PositionRowOrdinal ordinal = aList.get(i);
                        System.arraycopy(orderCopy, (int)(ordinal.getFirst() - origin), XV5PositionRowEdge.this.mOrder, (int)start, (int)ordinal.getSpan());
                        start += ordinal.getSpan();
                    }
                }

                private final class XV5PositionRowOrdinal {
                    private long mFirst;
                    private long mSpan;
                    private ContextBase mKey;

                    XV5PositionRowOrdinal(long first, long span, ContextBase key) {
                        this.mFirst = first;
                        this.mSpan = span;
                        this.mKey = key;
                    }

                    public long getFirst() {
                        return this.mFirst;
                    }

                    public long getSpan() {
                        return this.mSpan;
                    }

                    public ContextBase getKey() {
                        return this.mKey;
                    }
                }
            }
        }
    }
}

