/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.md.Cell;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.xml.XMLWriter;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5ResultSetConstructor
extends XNode {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_CELL = "Cell";
    public static final String ELEMENT_CONTEXTMEMBER = "ContextMember";
    public static final String ELEMENT_CONTEXTVALUE = "ContextValue";
    public static final String ATTRIBUTE_ROWSETID = "rowsetId";
    public static final String ATTRIBUTE_DATAITEMINDEX = "dataItemIndex";
    public static final String ATTRIBUTE_SUMMARY = "summary";
    public static final String ATTRIBUTE_QUERYCALCULATION = "queryCalculation";
    public static final String ELEMENT_MEMBER = "Member";
    public static final String ELEMENT_UNAME = "UName";
    public static final String ELEMENT_CAPTION = "Caption";
    public static final String ELEMENT_LNAME = "LName";
    public static final String ELEMENT_LNUM = "LNum";
    public static final String ELEMENT_VALUE = "Value";
    public static final String ATTRIBUTE_STATE = "state";
    public static final String ATTRIBUTE_DATATYPE = "dataType";
    public static final String ATTRIBUTE_HIERARCHY = "Hierarchy";
    public static final String ATTRIBUTE_CELLORDINAL = "CellOrdinal";
    private static final int EDGE_ORDINAL_OFFSET = 4;
    private RSAPIDataset mRSApiDataset;
    private Dimension[] mDimensions;
    private Map<String, Member> mMemberMap;
    private HashMapIntObject<RSAPIRowset> mRowsetMap = new HashMapIntObject();
    String mEdgeName;
    RowValue[][] mEdgeRows;
    ICell[] mCells;

    public XV5ResultSetConstructor() {
        this.mMemberMap = new THashMap();
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        XV5ResultSetConstructorResultSet v5Result = new XV5ResultSetConstructorResultSet(context, this);
        return new V5HybridResultSet(context, v5Result, this.getId());
    }

    @Override
    public int getType() {
        return 501084;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.processV5ResultSet(inputNode);
    }

    private void processV5ResultSet(Element eV5ResultSet) {
        Element eMetadata = eV5ResultSet.element("Metadata");
        this.processMetadata(eMetadata);
        Element eEdges = eV5ResultSet.element("Edges");
        List edges = eEdges.elements("Edge");
        this.mEdgeRows = new RowValue[edges.size()][];
        for (int iEdge = 0; iEdge < edges.size(); ++iEdge) {
            this.mEdgeRows[iEdge] = this.processEdge((Element)edges.get(iEdge));
        }
        Element eCellData = eV5ResultSet.element("CellData");
        List cells = eCellData.elements(ELEMENT_CELL);
        this.mCells = new ICell[cells.size()];
        for (int iCell = 0; iCell < cells.size(); ++iCell) {
            this.mCells[iCell] = this.processCell((Element)cells.get(iCell));
        }
    }

    private void processMetadata(Element eMetadata) {
        List eDimensions = eMetadata.elements("Dimension");
        this.mDimensions = new Dimension[eDimensions.size()];
        for (int iDim = 0; iDim < eDimensions.size(); ++iDim) {
            Dimension dimension;
            Element eDimension = (Element)eDimensions.get(iDim);
            String name = eDimension.attributeValue(ELEMENT_NAME);
            this.mDimensions[iDim] = dimension = new Dimension(name);
            name = eDimension.attributeValue("uniqueName");
            if (name != null) {
                dimension.setUniqueName(name);
            }
            List eHierarchies = eDimension.elements(ATTRIBUTE_HIERARCHY);
            for (int iHier = 0; iHier < eHierarchies.size(); ++iHier) {
                Element eHierarchy = (Element)eHierarchies.get(iHier);
                name = eHierarchy.attributeValue(ELEMENT_NAME);
                Hierarchy hierarchy = new Hierarchy(name);
                dimension.addHierarchy(hierarchy);
                hierarchy.setDimension(dimension);
                name = eHierarchy.attributeValue("uniqueName");
                if (name != null) {
                    hierarchy.setUniqueName(name);
                }
                List eLevels = eHierarchy.elements("Level");
                for (int iLevel = 0; iLevel < eLevels.size(); ++iLevel) {
                    Element eLevel = (Element)eLevels.get(iLevel);
                    name = eLevel.attributeValue(ELEMENT_NAME);
                    Level level = new Level(name);
                    name = eLevel.attributeValue("uniqueName");
                    if (name != null) {
                        level.setUniqueName(name);
                    }
                    hierarchy.addLevel(level);
                    level.setHierarchy(hierarchy);
                    level.setInitialised();
                }
                hierarchy.setInitialised();
            }
            dimension.setInitialised();
        }
    }

    private ILevel findLevel(String sHierarchy, String sLevel) {
        for (int iDim = 0; iDim < this.mDimensions.length; ++iDim) {
            Dimension dimension = this.mDimensions[iDim];
            for (int iHier = 0; iHier < dimension.getHierarchyCount(); ++iHier) {
                IHierarchy hierarchy = dimension.getHierarchy(iHier);
                if (!hierarchy.getUniqueName().equals(sHierarchy)) continue;
                for (int iLevel = 0; iLevel < hierarchy.getLevelCount(); ++iLevel) {
                    ILevel level = hierarchy.getLevel(iLevel);
                    if (!level.getUniqueName().equals(sLevel)) continue;
                    return level;
                }
            }
        }
        return null;
    }

    private RowValue[] processEdge(Element eEdge) {
        this.mEdgeName = eEdge.attributeValue(ELEMENT_NAME);
        Element eV5Rows = eEdge.element("V5Rows");
        List v5Rows = eV5Rows.elements("V5Row");
        RowValue[] rows = new RowValue[v5Rows.size()];
        for (int iRow = 0; iRow < v5Rows.size(); ++iRow) {
            Element row = (Element)v5Rows.get(iRow);
            List contexts = row.elements();
            IValue[] rowContents = new IValue[contexts.size()];
            for (int iContext = 0; iContext < contexts.size(); ++iContext) {
                Element context = (Element)contexts.get(iContext);
                ContextBase contextBase = this.processContextBase(context);
                rowContents[iContext] = (IValue)((Object)contextBase);
            }
            rows[iRow] = DataValueFactory.createRowValue(rowContents);
        }
        return rows;
    }

    private ContextBase processContextBase(Element eContextBase) {
        String sRowsetId = eContextBase.attributeValue(ATTRIBUTE_ROWSETID);
        String sDataItemIndex = eContextBase.attributeValue(ATTRIBUTE_DATAITEMINDEX);
        String sSummary = eContextBase.attributeValue(ATTRIBUTE_SUMMARY);
        String sQueryCalculation = eContextBase.attributeValue(ATTRIBUTE_QUERYCALCULATION);
        Element eContextMember = eContextBase.element(ELEMENT_CONTEXTMEMBER);
        ContextMember nestedContextMember = null;
        if (eContextMember != null) {
            nestedContextMember = (ContextMember)this.processContextBase(eContextMember);
        }
        ContextBase contextBase = null;
        if (eContextBase.getName() == ELEMENT_CONTEXTMEMBER) {
            Element eMember;
            String sUName;
            Member member;
            contextBase = new ContextMember();
            if (sQueryCalculation != null && sQueryCalculation.length() > 0) {
                contextBase.setQueryCalculation(Boolean.valueOf(sQueryCalculation));
            }
            if (sSummary != null && sSummary.length() > 0) {
                contextBase.setSummary(Boolean.valueOf(sSummary));
            }
            if ((member = this.mMemberMap.get(sUName = this.processProperty(eMember = eContextBase.element(ELEMENT_MEMBER), ELEMENT_UNAME))) == null) {
                member = new Member();
                String sHierarchy = eMember.attributeValue(ATTRIBUTE_HIERARCHY);
                String sCaption = this.processProperty(eMember, ELEMENT_CAPTION);
                String sLName = this.processProperty(eMember, ELEMENT_LNAME);
                ILevel level = this.findLevel(sHierarchy, sLName);
                member.setLevel(level);
                member.setName(sCaption);
                member.setUniqueName(sUName);
                member.setCaption(sCaption);
                this.mMemberMap.put(sUName, member);
            }
            contextBase.setMember(member);
        } else if (eContextBase.getName() == ELEMENT_CONTEXTVALUE) {
            Element eValue = eContextBase.element(ELEMENT_VALUE);
            String sValue = this.processProperty(eValue);
            DoubleValue dv = DataValueFactory.createDoubleValue();
            String sState = eValue.attributeValue(ATTRIBUTE_STATE);
            if (sState != null && !sState.equals("")) {
                dv.setState(this.parseState(sState));
            } else {
                dv.set(sValue);
            }
            contextBase = new ContextValue(dv);
        } else {
            this.throwInternalError("ContextBase is not a Member or Value");
        }
        contextBase.setRowset(this.getRSAPIRowset(Integer.parseInt(sRowsetId)));
        contextBase.setDataItemIndex(Integer.parseInt(sDataItemIndex));
        contextBase.setContextMember(nestedContextMember);
        return contextBase;
    }

    private ICell processCell(Element eCell) {
        String sOrdinal = eCell.attributeValue(ATTRIBUTE_CELLORDINAL);
        Element eContextValue = eCell.element(ELEMENT_CONTEXTVALUE);
        Element eValue = eContextValue != null ? eContextValue.element(ELEMENT_VALUE) : eCell.element(ELEMENT_VALUE);
        String sValue = this.processProperty(eValue);
        DoubleValue dv = DataValueFactory.createDoubleValue();
        String sState = eValue.attributeValue(ATTRIBUTE_STATE);
        if (sState != null && !sState.equals("")) {
            dv.setState(this.parseState(sState));
        } else {
            dv.set(sValue);
        }
        long iOrdinal = Integer.parseInt(sOrdinal);
        Cell cell = new Cell(iOrdinal, dv);
        return cell;
    }

    private String processProperty(Element eNode, String sPropertyName) {
        Element eChild = eNode.element(sPropertyName);
        if (eChild == null) {
            return "";
        }
        return this.processProperty(eChild);
    }

    private String processProperty(Element eNode) {
        String sData = (String)eNode.getData();
        return sData;
    }

    private RSAPIRowset getRSAPIRowset(int rowsetId) {
        RSAPIRowset rowset = null;
        if (this.mRSApiDataset != null) {
            if (this.mRSApiDataset.getCellRowset() == null) {
                RSAPIEdge edge = this.mRSApiDataset.getEdge(0);
                if (edge != null) {
                    return edge.getRowset(rowsetId);
                }
                return null;
            }
            if (this.mEdgeName != null) {
                int edgeOrdinal = Integer.parseInt(this.mEdgeName.substring(4));
                RSAPIEdge edge = this.mRSApiDataset.getEdge(edgeOrdinal);
                return edge.getRowset(rowsetId);
            }
            return this.mRSApiDataset.getCellRowset();
        }
        Integer intObj = XQEIntegerPool.getInteger(rowsetId);
        rowset = this.mRowsetMap.get(intObj);
        if (rowset == null) {
            rowset = new RSAPIEdgeRowset();
            rowset.setRowsetId(rowsetId);
            this.mRowsetMap.put(intObj, rowset);
        }
        return rowset;
    }

    private ValueState parseState(String state) {
        if (state.equalsIgnoreCase("null")) {
            return ValueState.NULL;
        }
        if (state.equalsIgnoreCase("error")) {
            return ValueState.ERROR;
        }
        if (state.equalsIgnoreCase("na")) {
            return ValueState.NOT_APPLICABLE;
        }
        if (state.equalsIgnoreCase("divbyzero")) {
            return ValueState.DIV_BY_ZERO;
        }
        if (state.equalsIgnoreCase("overflow")) {
            return ValueState.OVERFLOW;
        }
        if (state.equalsIgnoreCase("security")) {
            return ValueState.SECURITY_VIOLATION;
        }
        return ValueState.UNKNOWN;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private final class XV5ResultSetConstructorResultSet
    extends V5ResultSet {
        XV5ResultSetConstructorResultSet(XDataContext context, XNode node) {
            super(context, node, null);
        }

        @Override
        public long getV5EdgeSize(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            return XV5ResultSetConstructor.this.mEdgeRows[edgeNum].length;
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            return (XScrollableIterator)this.getScrollableV5EdgeIterator(edge);
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            return new XV5ResultSetConstructorScrollableEdgeIterator(this.getDataContext(), edge);
        }

        @Override
        public XCellIterator getV5CellIterator() {
            return this.getScrollableV5CellIterator();
        }

        @Override
        public XScrollableCellIterator getScrollableV5CellIterator() {
            return new XV5ResultSetConstructorScrollableCellIterator(this.getDataContext());
        }

        @Override
        public void toXML(XMLWriter xmlWriter) {
            super.toXML(xmlWriter);
        }

        private final class XV5ResultSetConstructorScrollableCellIterator
        extends V5ScrollableMappedCellIterator {
            XV5ResultSetConstructorScrollableCellIterator(XDataContext xDataContext) {
                super(xDataContext, XV5ResultSetConstructorResultSet.this.mThisV5ResultSet, null, XV5ResultSetConstructor.this.getId());
            }

            @Override
            public ICell byOrdinal(long ordinal) {
                ICell cell = XV5ResultSetConstructor.this.mCells[(int)ordinal];
                return cell;
            }
        }

        private final class XV5ResultSetConstructorScrollableEdgeIterator
        extends V5ScrollableMappedEdgeIterator {
            XV5ResultSetConstructorScrollableEdgeIterator(XDataContext xDataContext, RSAPIEdge edge) {
                super(xDataContext, XV5ResultSetConstructorResultSet.this.mThisV5ResultSet, edge, null, XV5ResultSetConstructor.this.getId());
            }

            @Override
            public Object current() {
                int edgeNum = this.mEdge.getPositionalOrdinal();
                if (this.currentIndex <= -1L || this.currentIndex >= (long)XV5ResultSetConstructor.this.mEdgeRows[edgeNum].length) {
                    return null;
                }
                return XV5ResultSetConstructor.this.mEdgeRows[edgeNum][(int)this.currentIndex];
            }
        }
    }
}

