/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.cellupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import org.dom4j.Element;

public final class XV5CellSpec {
    private int edgeNum;
    private int rowsetId;
    private int dataItemIndex;
    private String dataItemV5Name;
    public static final String ANYCALC = "AnyIntersectingCalculationName";
    public static final String ANYDBCALC = "AnyIntersectingDatabaseCalculationName";
    public static final String EXCLUDE = "Exclude_";
    public static final String EXCLUDE_LINK = "_";

    public XV5CellSpec(int theEdgeNum, int theRowsetId, int theDataItemIndex, String theDataItemV5Name) {
        this.edgeNum = theEdgeNum;
        this.rowsetId = theRowsetId;
        this.dataItemIndex = theDataItemIndex;
        this.dataItemV5Name = theDataItemV5Name != null && theDataItemV5Name.length() == 0 ? null : theDataItemV5Name;
    }

    public XV5CellSpec() {
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        this.edgeNum = Integer.parseInt(inputNode.attributeValue("EdgeNum"));
        this.rowsetId = Integer.parseInt(inputNode.attributeValue("RowsetId"));
        this.dataItemIndex = Integer.parseInt(inputNode.attributeValue("ColumnNum"));
        this.dataItemV5Name = String.valueOf(inputNode.attribute("ColumnNam"));
    }

    protected void dumpAdditionalAttributes(XQETrace trace) {
        trace.attribute("EdgeNum", Integer.toString(this.getEdgeNum()));
        trace.attribute("RowsetId", Integer.toString(this.getRowsetId()));
        trace.attribute("ColumnNum", Integer.toString(this.getDataItemIndex()));
        trace.attribute("ColumnNam", this.getDataItemV5Name());
    }

    public int getEdgeNum() {
        return this.edgeNum;
    }

    public int getRowsetId() {
        return this.rowsetId;
    }

    public int getDataItemIndex() {
        return this.dataItemIndex;
    }

    public String getDataItemV5Name() {
        return this.dataItemV5Name;
    }

    public boolean acceptRow(IValue[] columns) {
        boolean bResult = false;
        for (int i = 0; i < columns.length; ++i) {
            ContextMember aMember = null;
            IValue aColumn = columns[i];
            if (aColumn instanceof ContextValue) {
                aMember = ((ContextValue)aColumn).getContextMember();
            } else if (aColumn instanceof ContextMember) {
                aMember = (ContextMember)aColumn;
            }
            if (aMember == null || aMember.isNullContext() || this.rowsetId != aMember.getRowset().getRowsetId() || this.dataItemIndex != aMember.getDataItemIndex() || this.edgeNum != aMember.getRowset().getEdge().getPositionalOrdinal()) continue;
            if (this.dataItemV5Name == null) {
                bResult = true;
                break;
            }
            if (this.dataItemV5Name.equals(ANYDBCALC)) {
                if (!aMember.isDataBaseCalculation()) continue;
                bResult = true;
                break;
            }
            if (this.dataItemV5Name.equals(ANYCALC)) {
                if (!CalcMemberReferencePrefixes.isXQECalculation(aMember.getMember())) continue;
                bResult = true;
                break;
            }
            if (this.dataItemV5Name.equals(aMember.getV5UniqueName())) {
                bResult = true;
                break;
            }
            if (!this.dataItemV5Name.startsWith(EXCLUDE)) continue;
            bResult = !this.dataItemV5Name.contains(EXCLUDE_LINK + aMember.getV5UniqueName() + EXCLUDE_LINK);
            break;
        }
        return bResult;
    }
}

