/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.edgeupdate;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdateResultSet;
import com.cognos.xqe.runtree.v5.edgeupdate.SuppressedColumnEdge;
import com.cognos.xqe.runtree.v5.edgeupdate.SuppressedEdge;
import com.cognos.xqe.runtree.v5.edgeupdate.SuppressedRowEdge;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressByOrdinalSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressSpec;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

final class XSuppressionView {
    private boolean[] mRowsView;
    private boolean[] mColumnsView;
    private boolean[][] mEdgesView;
    private long[] mNumEdgeRows;
    private long[] mUpdatedNumEdgeRows;
    private long mNumRows;
    private long mNumColumns;
    private long cellEdgeSize;
    private long mUpdatedNumCol;
    private long mUpdatedNumRo;
    boolean isRowsViewSetup;
    private int mNumEdges;
    private RSAPIEdge[] mEdges;
    private int[] axisOrdering;
    private boolean isColumnMajorOrder;
    private boolean mHasMeasureRowset;
    private boolean keepHeaderFooterWithoutMeasures = true;

    XSuppressionView(IV5ResultSet baseResultSet, RSAPIEdge[] edges, int[] aAxisOrdering, boolean bIsColumnMajorOrder, boolean hasMeasureRowset) {
        this.mEdges = edges;
        this.mNumEdges = this.mEdges.length;
        this.isRowsViewSetup = true;
        this.axisOrdering = aAxisOrdering;
        this.isColumnMajorOrder = bIsColumnMajorOrder;
        this.mHasMeasureRowset = hasMeasureRowset;
        this.mNumEdgeRows = new long[this.mNumEdges];
        for (int i = 0; i < this.mNumEdges; ++i) {
            this.mNumEdgeRows[i] = baseResultSet.getV5EdgeSize(this.mEdges[i]);
        }
        if (this.mNumEdges == 1) {
            this.setNumRows(this.mNumEdgeRows[this.axisOrdering[0]]);
            this.setColumnsView(new boolean[(int)this.getNumRows()]);
        } else {
            this.setNumRows(this.mNumEdgeRows[this.axisOrdering[1]]);
            this.setNumColumns(this.mNumEdgeRows[this.axisOrdering[0]]);
            if (this.mEdges.length > 2) {
                this.setCellEdgeSize(this.mNumEdgeRows[this.axisOrdering[2]]);
            } else {
                this.setCellEdgeSize(0L);
            }
            this.setRowsView(new boolean[(int)this.getNumRows()]);
            this.setColumnsView(new boolean[(int)this.getNumColumns()]);
        }
    }

    XSuppressionView(IV5ResultSet baseResultSet, RSAPIEdge[] edges) {
        this.mEdges = edges;
        this.mNumEdges = this.mEdges.length;
        this.mNumEdgeRows = new long[this.mNumEdges];
        this.mUpdatedNumEdgeRows = new long[this.mNumEdges];
        this.mEdgesView = new boolean[this.mNumEdges][];
        for (int i = 0; i < this.mNumEdges; ++i) {
            this.mNumEdgeRows[i] = baseResultSet.getV5EdgeSize(this.mEdges[i]);
            this.mUpdatedNumEdgeRows[i] = this.mNumEdgeRows[i];
            this.setEdgeView(i, new boolean[(int)this.mNumEdgeRows[i]]);
        }
    }

    public long getNumEdgeRows(int edgeOrdinal) {
        return this.mNumEdgeRows[edgeOrdinal];
    }

    public void decrementNumEdgeRows(int edgeOrdinal) {
        int n = edgeOrdinal;
        this.mUpdatedNumEdgeRows[n] = this.mUpdatedNumEdgeRows[n] - 1L;
    }

    public long getUpdatedNumEdgeRows(int edgeOrdinal) {
        return this.mUpdatedNumEdgeRows[edgeOrdinal];
    }

    public void setNumRows(long numRows) {
        this.mNumRows = numRows;
    }

    public long getNumRows() {
        return this.mNumRows;
    }

    public void setUpdatedNumCol(long updatedNumCol) {
        this.mUpdatedNumCol = updatedNumCol;
    }

    public long getUpdatedNumCol() {
        return this.mUpdatedNumCol;
    }

    public void setNumColumns(long numColumns) {
        this.mNumColumns = numColumns;
    }

    public long getNumColumns() {
        return this.mNumColumns;
    }

    public void setUpdatedNumRow(long updatedNumRo) {
        this.mUpdatedNumRo = updatedNumRo;
    }

    public long getUpdatedNumRow() {
        return this.mUpdatedNumRo;
    }

    void setUpCrosstabView(AbstractXV5EdgeUpdateResultSet resultset, List<XSuppressSpec> suppressSpecs, boolean checkForSpacers) {
        XScrollableCellIterator baseCellIterator = resultset.getBaseCellIterator();
        XSuppressSpec suppressSpecRowAxe = null;
        XSuppressSpec suppressSpecColumnAxe = null;
        for (XSuppressSpec suppressSpec : suppressSpecs) {
            int edgeNum = suppressSpec.getEdgeNum();
            if (edgeNum == this.axisOrdering[1]) {
                suppressSpecRowAxe = suppressSpec;
                continue;
            }
            if (edgeNum != this.axisOrdering[0]) continue;
            suppressSpecColumnAxe = suppressSpec;
        }
        IScrollableIterator edgeIterator = null;
        if (checkForSpacers) {
            edgeIterator = resultset.getScrollableV5EdgeIterator(this.mEdges[this.axisOrdering[1]]);
        }
        this.setupRowsCrosstab(baseCellIterator, edgeIterator, suppressSpecRowAxe);
        if (checkForSpacers) {
            edgeIterator = resultset.getScrollableV5EdgeIterator(this.mEdges[this.axisOrdering[0]]);
        }
        this.setupColumnCrosstab(baseCellIterator, edgeIterator, suppressSpecColumnAxe);
    }

    public void setColumnsView(boolean[] columnsView) {
        this.mColumnsView = columnsView;
    }

    public boolean[] getColumnsView() {
        return this.mColumnsView;
    }

    public void setRowsView(boolean[] rowsView) {
        this.mRowsView = rowsView;
    }

    public boolean[] getRowsView() {
        return this.mRowsView;
    }

    public void setEdgeView(int edgeOrdinal, boolean[] edgeView) {
        this.mEdgesView[edgeOrdinal] = edgeView;
    }

    public boolean[] getEdgeView(int edgeOrdinal) {
        return this.mEdgesView[edgeOrdinal];
    }

    public void setCellEdgeSize(long nCellEdgeSize) {
        this.cellEdgeSize = nCellEdgeSize;
    }

    public long getCellEdgeSize() {
        return this.cellEdgeSize;
    }

    public int getNumEdges() {
        return this.mNumEdges;
    }

    private void setupRowsCrosstab(XScrollableCellIterator baseCellIterator, IScrollableIterator baseRowIterator, XSuppressSpec suppressSpec) {
        if (suppressSpec == null) {
            this.isRowsViewSetup = false;
            return;
        }
        if (this.getNumColumns() == 0L) {
            this.setupRowsForEmptyColumnCrosstab(baseCellIterator, baseRowIterator, suppressSpec);
            return;
        }
        if (this.getNumRows() == 0L) {
            return;
        }
        if (!this.mHasMeasureRowset) {
            return;
        }
        int i = 0;
        while ((long)i < this.getNumRows()) {
            if (baseRowIterator != null && this.rowHasNoCellValueSpacer(baseRowIterator, i)) {
                this.getRowsView()[i] = false;
                this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
            } else {
                int index = 0;
                index = this.isColumnMajorOrder ? i : i * (int)this.getNumColumns();
                int j = 0;
                while ((long)j < this.getNumColumns()) {
                    ICell cell = baseCellIterator.byOrdinal(index);
                    index = this.isColumnMajorOrder ? (index += (int)this.getNumRows()) : ++index;
                    Value val = null;
                    if (cell != null) {
                        val = cell.getValue() instanceof ContextValue ? (Value)((ContextValue)cell.getValue()).getValue() : (Value)cell.getValue();
                    }
                    if (!this.testMeasureValue(val, suppressSpec)) {
                        this.getRowsView()[i] = false;
                        this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void setupRowsForEmptyColumnCrosstab(XScrollableCellIterator baseCellIterator, IScrollableIterator baseRowIterator, XSuppressSpec suppressSpec) {
        int index = 0;
        int i = 0;
        while ((long)i < this.getNumRows()) {
            if (baseRowIterator != null && this.rowHasNoCellValueSpacer(baseRowIterator, i)) {
                this.getRowsView()[i] = false;
                this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
            } else {
                ICell cell = baseCellIterator.byOrdinal(index);
                Value val = null;
                if (cell != null) {
                    val = cell.getValue() instanceof ContextValue ? (Value)((ContextValue)cell.getValue()).getValue() : (Value)cell.getValue();
                }
                ++index;
                if (!this.testMeasureValue(val, suppressSpec)) {
                    this.getRowsView()[i] = false;
                    this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
                }
            }
            ++i;
        }
    }

    private void setupColumnCrosstab(XScrollableCellIterator baseCellIterator, IScrollableIterator baseColumnIterator, XSuppressSpec suppressSpec) {
        if (suppressSpec == null) {
            return;
        }
        if (this.getNumColumns() == 0L) {
            return;
        }
        if (this.getNumRows() == 0L) {
            this.setupColumnForEmptyRowCrosstab(baseCellIterator, suppressSpec);
            return;
        }
        if (!this.mHasMeasureRowset) {
            return;
        }
        int j = 0;
        while ((long)j < this.getNumColumns()) {
            if (baseColumnIterator != null && this.rowHasNoCellValueSpacer(baseColumnIterator, j)) {
                this.getColumnsView()[j] = false;
                this.setUpdatedNumCol(this.getUpdatedNumCol() + 1L);
            } else {
                int index = 0;
                index = this.isColumnMajorOrder ? j * (int)this.getNumRows() : j;
                int i = 0;
                while ((long)i < this.getNumRows()) {
                    if (this.isRowsViewSetup && this.getRowsView()[i]) {
                        index = this.isColumnMajorOrder ? ++index : (index += (int)this.getNumColumns());
                    } else {
                        ICell cell = baseCellIterator.byOrdinal(index);
                        index = this.isColumnMajorOrder ? ++index : (index += (int)this.getNumColumns());
                        Value val = null;
                        if (cell != null) {
                            val = cell.getValue() instanceof ContextValue ? (Value)((ContextValue)cell.getValue()).getValue() : (Value)cell.getValue();
                        }
                        if (!this.testMeasureValue(val, suppressSpec)) {
                            this.getColumnsView()[j] = false;
                            this.setUpdatedNumCol(this.getUpdatedNumCol() + 1L);
                            break;
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private void setupColumnForEmptyRowCrosstab(XScrollableCellIterator baseCellIterator, XSuppressSpec suppressSpec) {
        int index = 0;
        int i = 0;
        while ((long)i < this.getNumColumns()) {
            ICell cell = baseCellIterator.byOrdinal(index);
            Value val = null;
            if (cell != null) {
                val = cell.getValue() instanceof ContextValue ? (Value)((ContextValue)cell.getValue()).getValue() : (Value)cell.getValue();
            }
            ++index;
            if (!this.testMeasureValue(val, suppressSpec)) {
                this.getColumnsView()[i] = false;
                this.setUpdatedNumCol(this.getUpdatedNumCol() + 1L);
            }
            ++i;
        }
    }

    boolean testMeasureValue(Value value, XSuppressSpec suppressSpec) {
        if (value == null && suppressSpec.mNulls) {
            return true;
        }
        if (value == null && !suppressSpec.mNulls) {
            return false;
        }
        if (value.isNA() || value.isError() || value.isSecurityViolation()) {
            return false;
        }
        if (value.isNull() && suppressSpec.mNulls) {
            return true;
        }
        if (value.isDivByZero() && suppressSpec.mDivByZero) {
            return true;
        }
        if (value.isOverflow() && suppressSpec.mOverflow) {
            return true;
        }
        if (suppressSpec.mZero && value.isNumeric()) {
            return ((NumericValue)value).isZero();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUpListSuppressionView(AbstractXV5EdgeUpdateResultSet resultset, List<XSuppressSpec> suppressSpecs) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.keepHeaderFooterWithoutMeasures = config.getBooleanProperty("queryPlanning.keepHeaderFooterWithoutMeasures[@enabled]", true);
        HashMap<Integer, Integer> mEmptyHeaderOrFooterWithParentRowsets = null;
        XSuppressSpec suppressSpecAxe0 = null;
        for (XSuppressSpec suppressSpec : suppressSpecs) {
            int edgeNum = suppressSpec.getEdgeNum();
            if (edgeNum == 0) {
                suppressSpecAxe0 = suppressSpec;
                continue;
            }
            return;
        }
        mEmptyHeaderOrFooterWithParentRowsets = new HashMap<Integer, Integer>();
        for (int inx = 0; inx < this.mEdges[0].getNumRowsets(); ++inx) {
            RSAPIEdgeRowset rowset = this.mEdges[0].getRowset(inx);
            if (!rowset.isFooterRowset() && !rowset.isHeaderRowset() || rowset.getNumColumns() != 0 || rowset.getParentRowset() == null) continue;
            Integer emptyHeaderFooterId = XQEIntegerPool.getInteger(rowset.getRowsetId());
            Integer rowsetParentId = XQEIntegerPool.getInteger(rowset.getParentRowset().getRowsetId());
            mEmptyHeaderOrFooterWithParentRowsets.put(emptyHeaderFooterId, rowsetParentId);
        }
        int parentRowIndex = -1;
        XIterator baseIterator = resultset.getV5EdgeIterator(this.mEdges[0]);
        try {
            int index = 0;
            while ((long)index < this.getNumRows()) {
                RowValue row = (RowValue)baseIterator.next();
                if (row == null) {
                    break;
                }
                boolean isEmptyHeaderOrFooterWithParentRowsets = false;
                if (row.isSummary() && mEmptyHeaderOrFooterWithParentRowsets.size() != 0) {
                    for (int inx = 0; inx < row.getNumColumns(); ++inx) {
                        Integer id;
                        ContextBase col = (ContextBase)((Object)row.getColumn(inx));
                        if (col.getRowset() == null || !mEmptyHeaderOrFooterWithParentRowsets.containsKey(id = XQEIntegerPool.getInteger(col.getRowset().getRowsetId()))) continue;
                        parentRowIndex = index;
                        isEmptyHeaderOrFooterWithParentRowsets = true;
                    }
                }
                boolean rowWithoutValue = true;
                for (int i = 0; i < row.getNumColumns(); ++i) {
                    IValue value = row.getColumn(i);
                    if (!this.isColumnValueMeasure(value)) continue;
                    rowWithoutValue = false;
                    Value val = (Value)((ContextValue)value).getValue();
                    if (this.testMeasureValue(val, suppressSpecAxe0)) continue;
                    this.getColumnsView()[index] = false;
                    if (parentRowIndex != index) {
                        this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
                    }
                    if (index == parentRowIndex || mEmptyHeaderOrFooterWithParentRowsets.size() == 0 || parentRowIndex == -1) break;
                    this.getColumnsView()[parentRowIndex] = false;
                    this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
                    parentRowIndex = -1;
                    break;
                }
                if (rowWithoutValue) {
                    if (isEmptyHeaderOrFooterWithParentRowsets) {
                        this.getColumnsView()[parentRowIndex] = false;
                        this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
                        parentRowIndex = -1;
                    } else if (this.keepHeaderFooterWithoutMeasures && this.isRowWithoutMeasure(row)) {
                        this.getColumnsView()[index] = false;
                        this.setUpdatedNumRow(this.getUpdatedNumRow() + 1L);
                    }
                }
                ++index;
            }
        }
        finally {
            baseIterator.release();
        }
    }

    boolean isRowWithoutMeasure(RowValue row) {
        boolean emptyRow = true;
        for (int i = 0; i < row.getNumColumns(); ++i) {
            ContextValue v;
            IValue value = row.getColumn(i);
            if (value.isNull()) {
                if (!this.isColumnValueMeasure(value)) continue;
                return false;
            }
            if (value instanceof ContextMember) {
                return false;
            }
            if (value instanceof ContextValue && ((v = (ContextValue)value).getDataItemIndex() == -2 || v.getDataItemIndex() == -1)) continue;
            emptyRow = false;
        }
        return !emptyRow;
    }

    boolean isColumnValueMeasure(IValue value) {
        if (!(value instanceof ContextValue)) {
            return false;
        }
        ContextValue v = (ContextValue)value;
        RSAPIRowset rowset = v.getRowset();
        if (v.getDataItemIndex() == -1) {
            RSAPIEdgeRowset rs = (RSAPIEdgeRowset)rowset;
            if (rs != null && rs.getRefDataItem().getUsage() != RSAPIUsage.FACT) {
                return false;
            }
        } else {
            if (v.getDataItemIndex() == -2) {
                return false;
            }
            if (rowset != null) {
                RSAPIDataItem di = rowset.getDataItem(v.getDataItemIndex());
                if (di.getUsage() != RSAPIUsage.FACT) {
                    return false;
                }
                if (di.getUsage() == RSAPIUsage.FACT && di.isConstant()) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setupValueBasedSuppression(AbstractXV5EdgeUpdateResultSet resultset, List<XSuppressSpec> suppressSpecs, boolean checkForSpacers) {
        if (this.mNumEdges == 1) {
            Arrays.fill(this.getColumnsView(), true);
        } else {
            Arrays.fill(this.getColumnsView(), true);
            Arrays.fill(this.getRowsView(), true);
        }
        this.buildSuppressedAxis(resultset, suppressSpecs, checkForSpacers);
        resultset.setupNewOrdinalsOnSuppressedAxis();
    }

    public void setupOrdinalBasedSuppression(AbstractXV5EdgeUpdateResultSet resultset, List<XSuppressByOrdinalSpec> suppressSpecs) {
        for (XSuppressByOrdinalSpec suppressSpec : suppressSpecs) {
            if (suppressSpec.getOrdinal() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Result is too large");
            }
            int ordinal = (int)suppressSpec.getOrdinal();
            int edgeNum = suppressSpec.getEdgeNum();
            boolean[] edgeView = this.getEdgeView(edgeNum);
            if (edgeView[ordinal]) continue;
            edgeView[ordinal] = true;
            this.decrementNumEdgeRows(edgeNum);
        }
        for (int i = 0; i < this.getNumEdges(); ++i) {
            if (this.getNumEdgeRows(i) == this.getUpdatedNumEdgeRows(i)) continue;
            resultset.mSuppressedEdges[i] = new SuppressedEdge(this.mEdges[i], resultset.getBaseResultSet(), this, i);
        }
        resultset.setupNewOrdinalsOnSuppressedAxis();
    }

    private void buildSuppressedAxis(AbstractXV5EdgeUpdateResultSet resultset, List<XSuppressSpec> suppressSpecs, boolean checkForSpacers) {
        if (this.mNumEdges > 1) {
            this.setUpCrosstabView(resultset, suppressSpecs, checkForSpacers);
        }
        if (this.mNumEdges == 1) {
            this.setUpListSuppressionView(resultset, suppressSpecs);
        }
        for (XSuppressSpec suppressSpec : suppressSpecs) {
            int edgeNum = suppressSpec.getEdgeNum();
            if (resultset.mSuppressedEdges[edgeNum] != null) continue;
            if (this.mNumEdges == 1 || edgeNum == this.axisOrdering[0]) {
                resultset.mSuppressedEdges[edgeNum] = new SuppressedColumnEdge(this.mEdges[edgeNum], resultset.getBaseResultSet(), this.mHasMeasureRowset, this);
                continue;
            }
            if (edgeNum != this.axisOrdering[1]) continue;
            resultset.mSuppressedEdges[edgeNum] = new SuppressedRowEdge(this.mEdges[edgeNum], resultset.getBaseResultSet(), this.mHasMeasureRowset, this);
        }
    }

    private boolean rowHasNoCellValueSpacer(IScrollableIterator edgeIterator, int rowNumber) {
        ContextMember contextMember;
        edgeIterator.absolute(rowNumber);
        RowValue rowValue = (RowValue)edgeIterator.current();
        if (rowValue == null) {
            return false;
        }
        if (rowValue.getNumColumns() > 1) {
            return false;
        }
        ContextBase column = (ContextBase)((Object)rowValue.getColumn(0));
        return column instanceof ContextMember && (contextMember = (ContextMember)column).isCrosstabSpacer() == 0;
    }
}

