/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.edgeupdate;

import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdate;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdateResultSet;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressionView;
import java.util.Arrays;

public final class XV5SuppressResultSet
extends AbstractXV5EdgeUpdateResultSet {
    boolean isColumnMajorOrder = false;

    XV5SuppressResultSet(XDataContext context, AbstractXV5EdgeUpdate xV5EdgeUpdate, IV5ResultSet sourceResultSet) {
        super(context, xV5EdgeUpdate, sourceResultSet);
        this.setMdxEdgeOrder();
        this.isColumnMajorOrder = this.isColumnMajorOrder();
        this.mSuppressionView = new XSuppressionView(this.getBaseResultSet(), this.mEdges, this.axisOrdering, this.isColumnMajorOrder, this.mHasMeasureRowset);
    }

    private void setMdxEdgeOrder() {
        int[] v5EdgeOrdering = new int[this.mNumEdges];
        this.axisOrdering = new int[this.mNumEdges];
        for (int edgeNum = 0; edgeNum < this.mEdges.length; ++edgeNum) {
            RSAPIEdge edge = this.mEdges[edgeNum];
            v5EdgeOrdering[edgeNum] = edge.getOrdinal();
        }
        Arrays.sort(v5EdgeOrdering);
        for (int i = 0; i < v5EdgeOrdering.length; ++i) {
            for (int j = 0; j < this.mEdges.length; ++j) {
                if (this.mEdges[j].getOrdinal() != v5EdgeOrdering[i]) continue;
                this.axisOrdering[i] = j;
            }
        }
    }

    private boolean isColumnMajorOrder() {
        boolean isAnsSpec = false;
        if (this.axisOrdering.length > 1 && (this.axisOrdering[0] == 2 || this.axisOrdering[0] == 1 && this.axisOrdering[1] == 0)) {
            isAnsSpec = true;
        }
        return isAnsSpec;
    }

    @Override
    public void releaseImpl() {
        super.releaseImpl();
    }

    @Override
    public XCellIterator getV5CellIterator() {
        return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), this.getId());
    }

    @Override
    public XScrollableCellIterator getScrollableV5CellIterator() {
        return new V5ScrollableMappedCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), this.getId());
    }
}

