/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.listupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public final class XV5ListColumnValueSpec {
    private int edgeNum;
    private int rowsetId;
    private int dataItemIndex;
    private String dataItemDecoName;
    static final String EDGENUM = "EdgeNum";
    static final String ROWSETID = "RowsetId";
    static final String COLUMNNUM = "ColumnNum";
    static final String COLUMNNAM = "ColumnNam";
    public static final String XPRIMARYCOLVALUESPEC = "XPrimaryColValueSpec";
    public static final String XV5ERRORCELLUPDATERULE = "XV5ErrorCellUpdateRule";
    public static final String PROJECTED_SUMMARY_ROLLUP_NONE = "ProjectedSummaryWithRollupAggregateNone";
    public static final String UNKNOWN_AGGREGATE = "UnknownAggregate";

    public XV5ListColumnValueSpec(int theEdgeNum, int theRowsetId, int theDataItemIndex, String theDataItemV5Name) {
        this.edgeNum = theEdgeNum;
        this.rowsetId = theRowsetId;
        this.dataItemIndex = theDataItemIndex;
        this.dataItemDecoName = theDataItemV5Name != null && theDataItemV5Name.length() == 0 ? null : theDataItemV5Name;
    }

    public XV5ListColumnValueSpec() {
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        this.edgeNum = Integer.parseInt(inputNode.attributeValue(EDGENUM));
        this.rowsetId = Integer.parseInt(inputNode.attributeValue(ROWSETID));
        this.dataItemIndex = Integer.parseInt(inputNode.attributeValue(COLUMNNUM));
        this.dataItemDecoName = String.valueOf(inputNode.attribute(COLUMNNAM));
    }

    public void dumpAdditionalAttributes(XQETrace trace) {
        trace.attribute(EDGENUM, Integer.toString(this.getEdgeNum()));
        trace.attribute(ROWSETID, Integer.toString(this.getRowsetId()));
        trace.attribute(COLUMNNUM, Integer.toString(this.getDataItemIndex()));
        trace.attribute(COLUMNNAM, this.getDataItemDecoName());
    }

    public int getEdgeNum() {
        return this.edgeNum;
    }

    public int getRowsetId() {
        return this.rowsetId;
    }

    public int getDataItemIndex() {
        return this.dataItemIndex;
    }

    public String getDataItemDecoName() {
        return this.dataItemDecoName;
    }

    public boolean acceptRow(IValue[] columns) {
        boolean bResult = false;
        for (int i = 0; i < columns.length; ++i) {
            IValue aColumn = columns[i];
            ContextBase aContextBase = (ContextBase)((Object)aColumn);
            if (aContextBase == null || aContextBase.isNullContext() || this.rowsetId != aContextBase.getRowset().getRowsetId() || this.dataItemIndex != aContextBase.getDataItemIndex() || this.edgeNum != aContextBase.getRowset().getEdge().getPositionalOrdinal()) continue;
            if (this.dataItemDecoName == null) {
                bResult = true;
                break;
            }
            if (this.dataItemDecoName.equals(PROJECTED_SUMMARY_ROLLUP_NONE)) {
                bResult = true;
                break;
            }
            if (!this.dataItemDecoName.equals(UNKNOWN_AGGREGATE)) continue;
            bResult = true;
            break;
        }
        return bResult;
    }
}

