/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.source;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.source.ISource;
import com.ibm.json.java.JSONObject;

public abstract class AbstractSource
implements ISource {
    private static final long serialVersionUID = -4002041831171501379L;
    protected long lastModified;
    protected String name;
    protected String storeId;
    protected String searchPath;
    protected SourceType type;
    protected boolean live;

    public AbstractSource(String n, String sId, String sp, long lm, boolean l) {
        if (sId == null || sId.isEmpty()) {
            throw new XQERuntimeException();
        }
        this.name = n;
        this.storeId = sId;
        this.searchPath = sp;
        this.lastModified = lm;
        this.live = l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public String getSearchPath() {
        return this.searchPath;
    }

    @Override
    public SourceType getType() {
        return this.type;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public SourceCategory getCategory() {
        if (this.type != null) {
            return this.type.getCategory();
        }
        return null;
    }

    @Override
    public boolean isData() {
        return SourceCategory.DATA.equals((Object)this.getCategory());
    }

    @Override
    public boolean isMetadata() {
        return SourceCategory.METADATA.equals((Object)this.getCategory());
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put((Object)"name", (Object)this.name);
        result.put((Object)"storeID", (Object)this.storeId);
        result.put((Object)"searchPath", (Object)this.searchPath);
        String categoryName = null;
        String typeName = null;
        if (this.type != null) {
            typeName = this.type.getName();
            if (this.type.category != null) {
                categoryName = this.type.category.getName();
            }
        }
        result.put((Object)"category", categoryName);
        result.put((Object)"type", (Object)typeName);
        result.put((Object)"lastModified", (Object)this.lastModified);
        result.put((Object)"live", (Object)this.live);
        return result;
    }

    public int hashCode() {
        if (this.storeId == null) {
            return 0;
        }
        return this.storeId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractSource)) {
            return false;
        }
        AbstractSource other = (AbstractSource)obj;
        return !(this.storeId == null ? other.storeId != null : !this.storeId.equals(other.storeId));
    }

    @Override
    public int compareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (!(obj instanceof AbstractSource)) {
            return 1;
        }
        AbstractSource other = (AbstractSource)obj;
        if (this.storeId == null) {
            if (other.storeId != null) {
                return -1;
            }
            return 0;
        }
        return this.storeId.compareTo(other.storeId);
    }

    public static enum SourceType {
        DATASOURCE("dataSource", SourceCategory.DATA),
        UPLOADEDFILE("uploadedFile", SourceCategory.DATA),
        DATASET2("dataSet2", SourceCategory.DATA),
        MODULE("module", SourceCategory.METADATA),
        BASEMODULE("baseModule", SourceCategory.METADATA),
        MODEL("model", SourceCategory.METADATA),
        LW_OLAP("lwOLAP", SourceCategory.METADATA),
        REPORT("report", SourceCategory.METADATA);

        private final String name;
        private final SourceCategory category;

        private SourceType(String n2, SourceCategory c) {
            this.name = n2;
            this.category = c;
        }

        public String getName() {
            return this.name;
        }

        public SourceCategory getCategory() {
            return this.category;
        }
    }

    public static enum SourceCategory {
        DATA("data"),
        METADATA("metadata");

        private final String name;

        private SourceCategory(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }
    }
}

