/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public final class LogInvocationHandler
implements InvocationHandler {
    private static final String RETURN_PREFIX = "\t\t<return obj=\"";
    private static final String CALL_PREFIX = "\t</call>\n";
    private static final String ELEMENT_POSTFIX = "\"/>\n";
    private static final String ARG_PREFIX = "\t\t<arg obj=\"";
    private static final String OID_ATTR = "\" oID=\"";
    private static final String VALUE_ATTR = "\" value=\"";
    OutputStreamWriter log = null;
    static OutputStreamWriter globalLog;
    static boolean isLogInitialized;
    private static XQELogger mErrorLogger;
    static long newObjId;
    Object realObject;
    long objId;
    private static final String PROXY_INTERFACE_PACKAGE = "com.cognos.xqe.data.providers.analytics";
    private static HashMap<Class<?>, Class<?>[]> classToProxyMap;
    private static String globalLogFileNamePrefix;
    private static final String XML_FILE_EXTENSION = ".xml";
    private static String logsFolder;

    OutputStreamWriter getLog() {
        if (this.log != null) {
            return this.log;
        }
        if (!isLogInitialized) {
            globalLog = LogInvocationHandler.getNextLogOutputStream(null);
            isLogInitialized = true;
        }
        this.log = globalLog;
        return globalLog;
    }

    public static void setLog(OutputStreamWriter fLog) {
        globalLog = fLog;
        isLogInitialized = true;
    }

    private LogInvocationHandler(Object fRealObject) {
        this.realObject = fRealObject;
        this.objId = ++newObjId;
    }

    long getObjId() {
        return this.objId;
    }

    public Object getRealObject() {
        return this.realObject;
    }

    public static Object getRealObject(Object instance) {
        if (instance instanceof Proxy && Proxy.getInvocationHandler(instance) instanceof LogInvocationHandler) {
            return ((LogInvocationHandler)Proxy.getInvocationHandler((Object)instance)).realObject;
        }
        return instance;
    }

    public static Object createObjectWithProxy(Class<?> objectClass, Object[] classConstructorArgs) {
        return LogInvocationHandler.createObjectWithProxy(objectClass, classConstructorArgs, null);
    }

    public static Object createObjectWithProxy(Class<?> objectClass, Object[] classConstructorArgs, OutputStreamWriter outputLog) {
        Object realObject;
        Class<?>[] parameterTypes = LogInvocationHandler.getObjectTypes(null, classConstructorArgs);
        Object[] realConstructorArgs = LogInvocationHandler.getRealArgs(classConstructorArgs);
        try {
            realObject = objectClass.getConstructor(parameterTypes).newInstance(realConstructorArgs);
        }
        catch (Exception e) {
            throw new RuntimeException("Logging Proxy problem constructing " + objectClass.getName() + " class", e);
        }
        Proxy proxyObj = (Proxy)LogInvocationHandler.createProxy(realObject);
        LogInvocationHandler logProxyHandler = (LogInvocationHandler)Proxy.getInvocationHandler(proxyObj);
        if (outputLog != null) {
            logProxyHandler.setOutputLog(outputLog);
        } else {
            outputLog = logProxyHandler.getLog();
        }
        if (outputLog != null) {
            long objId = logProxyHandler.getObjId();
            Long[] argIds = LogInvocationHandler.extractObjIds(classConstructorArgs);
            LogInvocationHandler.logCreateObject(realConstructorArgs, argIds, realObject, objId, outputLog);
        }
        return proxyObj;
    }

    private void setOutputLog(OutputStreamWriter fOutputLog) {
        this.log = fOutputLog;
    }

    static Object createProxy(Object realObject) {
        Class<?>[] proxyInterfaces = realObject.getClass().getInterfaces();
        if (proxyInterfaces.length == 0) {
            proxyInterfaces = LogInvocationHandler.initProxyInterfaces(realObject.getClass());
        }
        Class<?> proxyClass = Proxy.getProxyClass(proxyInterfaces[0].getClassLoader(), proxyInterfaces);
        Object newProxyInstance = null;
        LogInvocationHandler loggingProxyHanlder = new LogInvocationHandler(realObject);
        try {
            newProxyInstance = proxyClass.getConstructor(InvocationHandler.class).newInstance(loggingProxyHanlder);
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return newProxyInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?>[] initProxyInterfaces(Class<?> objectClass) {
        HashMap<Class<?>, Class<?>[]> hashMap = classToProxyMap;
        synchronized (hashMap) {
            Class<?>[] interfaceClasses = classToProxyMap.get(objectClass);
            if (interfaceClasses == null) {
                Class<?> impliedInterfaceClass;
                String impliedInterfaceName = "com.cognos.xqe.data.providers.analytics.I" + objectClass.getSimpleName();
                try {
                    impliedInterfaceClass = Class.forName(impliedInterfaceName);
                }
                catch (ClassNotFoundException e) {
                    impliedInterfaceClass = null;
                }
                interfaceClasses = new Class[]{impliedInterfaceClass};
                classToProxyMap.put(objectClass, interfaceClasses);
            }
            return interfaceClasses;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?>[] parameterTypes = LogInvocationHandler.getObjectTypes(method.getParameterTypes(), args);
        Object[] realArgs = LogInvocationHandler.getRealArgs(args);
        Method realMethod = this.realObject.getClass().getMethod(method.getName(), parameterTypes);
        if (this.getLog() != null) {
            Long[] argIds = LogInvocationHandler.extractObjIds(args);
            LogInvocationHandler.logInvokeMethodBefore(method, this.realObject, this.objId, realArgs, argIds, parameterTypes, this.getLog());
        }
        Object returnArg = null;
        Long returnObjId = null;
        try {
            returnArg = realMethod.invoke(this.realObject, realArgs);
        }
        catch (Throwable e) {
            Throwable targetError = null;
            if (this.getLog() != null) {
                LogInvocationHandler.logInvokeMethodError(e, this.getLog());
            }
            if (e instanceof InvocationTargetException) {
                targetError = ((InvocationTargetException)e).getTargetException();
                e = LogInvocationHandler.initProxyInterfaces(targetError.getClass())[0] != null ? new InvocationException(LogInvocationHandler.createProxy(targetError)) : targetError;
            }
            throw e;
        }
        Object realReturnArg = returnArg;
        if (returnArg != null && LogInvocationHandler.initProxyInterfaces(returnArg.getClass())[0] != null) {
            returnArg = LogInvocationHandler.createProxy(returnArg);
            LogInvocationHandler logProxyHandler = (LogInvocationHandler)Proxy.getInvocationHandler(returnArg);
            logProxyHandler.setOutputLog(this.log);
            returnObjId = logProxyHandler.getObjId();
        }
        if (this.getLog() != null) {
            LogInvocationHandler.logInvokeMethodAfter(realReturnArg, returnObjId, this.getLog());
        }
        return returnArg;
    }

    private static Long[] extractObjIds(Object[] args) {
        if (args == null) {
            return null;
        }
        Long[] argIds = new Long[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (Proxy.isProxyClass(args[i].getClass())) {
                LogInvocationHandler logProxyHandler = (LogInvocationHandler)Proxy.getInvocationHandler(args[i]);
                argIds[i] = logProxyHandler.getObjId();
                continue;
            }
            argIds[i] = null;
        }
        return argIds;
    }

    public static void logCreateObject(Object[] classConstructorArgs, Long[] argIds, Object createdObj, Long createdObjId, OutputStreamWriter outputLog) {
        try {
            outputLog.write("\t<new obj=\"" + createdObj.getClass().getName() + OID_ATTR + createdObjId + "\"");
            if (classConstructorArgs != null) {
                outputLog.write(">\n");
                for (int iArg = 0; iArg < classConstructorArgs.length; ++iArg) {
                    Object argObj = classConstructorArgs[iArg];
                    if (argIds[iArg] != null) {
                        outputLog.write(ARG_PREFIX + argObj.getClass().getName() + OID_ATTR + argIds[iArg] + ELEMENT_POSTFIX);
                        continue;
                    }
                    if (argObj.getClass().isEnum()) {
                        outputLog.write(ARG_PREFIX + argObj.getClass().getName() + VALUE_ATTR + ((Enum)argObj).name() + ELEMENT_POSTFIX);
                        continue;
                    }
                    outputLog.write(ARG_PREFIX + argObj.getClass().getName() + VALUE_ATTR + argObj.toString() + ELEMENT_POSTFIX);
                }
                outputLog.write("\t</new>\n");
            } else {
                outputLog.write("/>\n");
            }
            outputLog.flush();
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
    }

    public static void logInvokeMethodAfter(Object returnObj, Long returnObjId, OutputStreamWriter outputLog) throws IOException {
        if (returnObj != null) {
            if (returnObjId != null) {
                outputLog.write(RETURN_PREFIX + returnObj.getClass().getName() + OID_ATTR + returnObjId + ELEMENT_POSTFIX);
            } else if (returnObj.getClass().isEnum()) {
                outputLog.write(RETURN_PREFIX + returnObj.getClass().getName() + VALUE_ATTR + ((Enum)returnObj).name() + ELEMENT_POSTFIX);
            } else {
                outputLog.write(RETURN_PREFIX + returnObj.getClass().getName() + VALUE_ATTR + returnObj.toString() + ELEMENT_POSTFIX);
            }
        }
        try {
            outputLog.write(CALL_PREFIX);
            outputLog.flush();
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
    }

    public static void logInvokeMethodError(Throwable e, OutputStreamWriter outputLog) throws IOException {
        outputLog.write("\t\t<error>\n");
        Throwable eInStack = null;
        for (eInStack = e; eInStack != null; eInStack = eInStack.getCause()) {
            if (e instanceof InvocationTargetException) {
                eInStack = ((InvocationTargetException)e).getTargetException();
            }
            outputLog.write("\t\t\t[" + eInStack.getClass().getName() + "] ");
            if (eInStack.getLocalizedMessage() != null) {
                outputLog.write(eInStack.getLocalizedMessage());
            }
            outputLog.write("\n");
        }
        outputLog.write("\t\t</error>\n");
        outputLog.write(CALL_PREFIX);
        outputLog.flush();
    }

    public static void logInvokeMethodBefore(Method method, Object obj, Long objId, Object[] args, Long[] argIds, Class<?>[] parameterTypes, OutputStreamWriter outputLog) {
        try {
            outputLog.write("\t<call obj=\"" + obj.getClass().getName() + OID_ATTR + objId + "\" method=\"" + method.getName() + "\">\n");
            if (args != null) {
                for (int iArg = 0; iArg < args.length; ++iArg) {
                    Object argObj = args[iArg];
                    if (argIds[iArg] != null) {
                        outputLog.write(ARG_PREFIX + argObj.getClass().getName() + OID_ATTR + argIds[iArg] + ELEMENT_POSTFIX);
                        continue;
                    }
                    if (parameterTypes[iArg].isEnum()) {
                        outputLog.write(ARG_PREFIX + parameterTypes[iArg].getName() + VALUE_ATTR + ((Enum)argObj).name() + ELEMENT_POSTFIX);
                        continue;
                    }
                    outputLog.write(ARG_PREFIX + parameterTypes[iArg].getName() + VALUE_ATTR + argObj.toString() + ELEMENT_POSTFIX);
                }
            }
            outputLog.flush();
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
    }

    private static Object[] getRealArgs(Object[] args) {
        if (args == null) {
            return null;
        }
        Object[] realArgs = new Object[args.length];
        for (int iParam = 0; iParam < args.length; ++iParam) {
            if (Proxy.isProxyClass(args[iParam].getClass())) {
                Proxy proxy = (Proxy)args[iParam];
                InvocationHandler handler = Proxy.getInvocationHandler(proxy);
                if (handler.getClass() == LogInvocationHandler.class) {
                    LogInvocationHandler loggingHandler = (LogInvocationHandler)handler;
                    realArgs[iParam] = loggingHandler.getRealObject();
                    continue;
                }
                realArgs[iParam] = args[iParam];
                continue;
            }
            realArgs[iParam] = args[iParam];
        }
        return realArgs;
    }

    private static Class<?>[] getObjectTypes(Class<?>[] parameterClasses, Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] parameterTypes = new Class[args.length];
        for (int iParam = 0; iParam < parameterTypes.length; ++iParam) {
            if (parameterClasses != null && parameterClasses[iParam].isPrimitive()) {
                parameterTypes[iParam] = parameterClasses[iParam];
                continue;
            }
            if (Proxy.isProxyClass(args[iParam].getClass())) {
                Proxy proxy = (Proxy)args[iParam];
                InvocationHandler handler = Proxy.getInvocationHandler(proxy);
                if (handler.getClass() == LogInvocationHandler.class) {
                    LogInvocationHandler loggingHandler = (LogInvocationHandler)handler;
                    parameterTypes[iParam] = loggingHandler.getRealObject().getClass();
                    continue;
                }
                parameterTypes[iParam] = args[iParam].getClass();
                continue;
            }
            parameterTypes[iParam] = args[iParam].getClass();
        }
        return parameterTypes;
    }

    public static void setLogFileNamePrefix(String fLogFileNamePrefix) {
        globalLogFileNamePrefix = fLogFileNamePrefix;
    }

    public static void setLogsFolder(String fLogsFolder) {
        logsFolder = fLogsFolder;
    }

    public static File getNextLogFile(String logFileNamePrefix) {
        String fileName;
        String xqeLogsFolder = logsFolder;
        File logFolder = new File(xqeLogsFolder);
        if (!logFolder.exists()) {
            return null;
        }
        File logFile = null;
        StringBuilder strBuf = null;
        int idx = 0;
        if (logFileNamePrefix == null) {
            logFileNamePrefix = globalLogFileNamePrefix;
        }
        do {
            strBuf = new StringBuilder();
            strBuf.append(xqeLogsFolder).append(File.separator).append(logFileNamePrefix);
            strBuf.append(idx++);
            strBuf.append(XML_FILE_EXTENSION);
        } while ((logFile = new File(fileName = strBuf.toString())).exists());
        return logFile;
    }

    public static synchronized OutputStreamWriter getNextLogOutputStream(String logFileNamePrefix) {
        try {
            File logFile = LogInvocationHandler.getNextLogFile(logFileNamePrefix);
            if (logFile != null) {
                FileOutputStream fos = new FileOutputStream(logFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                writer.write("<log>\n");
                writer.flush();
                return writer;
            }
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
        return null;
    }

    static {
        isLogInitialized = false;
        mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
        newObjId = 0L;
        classToProxyMap = new HashMap();
        globalLogFileNamePrefix = "ts";
        logsFolder = "../logs/analytics";
    }

    public class InvocationException
    extends RuntimeException {
        private static final long serialVersionUID = 2760370275717988158L;
        private Object target = null;

        public InvocationException(Object fTarget) {
            this.target = fTarget;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

