/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.MemoryUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RunStatsRecorder {
    private static final String STATS_FILE_EXT = ".csv";
    private static final String STATS_FILENAME = "/xqestats";
    private static final int VIRT_MEM = 1;
    private static final int WORK_SET = 2;
    private static final int PRIV_BYTES = 3;
    private static final int PEAK_PRIV_BYTES = 4;
    private static final int KBYTE_SIZE = 1024;
    private static final String COMMA = ",";
    private static RunStatsRecorder instance;
    private boolean enabled = false;
    private boolean perReport = false;
    private String command = null;
    private Pattern pattern = Pattern.compile("^[^ ]+\\s+\\d+\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*$");
    private PrintWriter memStatsFile;
    private Runtime runtime = Runtime.getRuntime();
    private long privateBytes = 0L;
    private long peakPrivateBytes = 0L;
    private long workingSet = 0L;
    private long peakWorkingSet = 0L;
    private long virtualSize = 0L;
    private long peakVirtualSize = 0L;
    private final boolean bDisableConsoleStats;
    private long previousJavaMemory = 0L;
    private static String pid;

    private RunStatsRecorder(boolean enable, boolean includePIDInFileName, boolean disableConsoleStats, boolean recordPerReport) {
        this.enabled = enable;
        this.bDisableConsoleStats = disableConsoleStats;
        if (!this.enabled) {
            return;
        }
        this.perReport = recordPerReport;
        RunStatsRecorder.getPID();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String statsFile = null;
        statsFile = includePIDInFileName ? config.getXqeLogsDirectory() + STATS_FILENAME + pid + STATS_FILE_EXT : config.getXqeLogsDirectory() + STATS_FILENAME + STATS_FILE_EXT;
        try {
            this.memStatsFile = new PrintWriter((Writer)new BufferedWriter(new FileWriter(statsFile)), true);
            this.memStatsFile.println("Group,Item,Virtual memory,Peak virtual memory,Working set,Peak working set,Private bytes,Peak private bytes,Java used memory,Java max memory size,Java current memory size,C++ memory(excluding JVM),Time");
            XQEDebugLog.err.println("Recording stats in " + statsFile);
        }
        catch (IOException e) {
            XQEDebugLog.err.println("Could not create stats file " + statsFile);
            XQEDebugLog.err.printStackTrace(e);
        }
    }

    public static String getPID() {
        if (pid == null) {
            String pidString = ManagementFactory.getRuntimeMXBean().getName();
            pid = pidString.substring(0, pidString.indexOf(64));
        }
        return pid;
    }

    public static synchronized RunStatsRecorder getInstance() {
        if (instance == null) {
            boolean enable = false;
            String value = System.getProperty("recordStats");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    XQEDebugLog.err.println("Currently we can only record memory stats on win32");
                } else {
                    enable = true;
                }
            }
            boolean recordPerReport = false;
            value = System.getProperty("recordStats.perReport");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                recordPerReport = true;
            }
            boolean disableConsoleStats = false;
            value = System.getProperty("recordStats.disableConsoleStats");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                disableConsoleStats = true;
            }
            boolean includePIDInFileName = true;
            value = System.getProperty("recordStats.noPIDInFileName");
            if (value != null && Boolean.valueOf(value).booleanValue()) {
                includePIDInFileName = false;
            }
            instance = new RunStatsRecorder(enable, includePIDInFileName, disableConsoleStats, recordPerReport);
        }
        return instance;
    }

    public synchronized void record(String group, String item, boolean recordingForReport, long startTime) {
        if (!this.enabled) {
            return;
        }
        if (recordingForReport != this.perReport) {
            return;
        }
        String recordGroup = group;
        if (recordingForReport) {
            if (recordGroup == null) {
                return;
            }
            if (recordGroup.equals("releaseDataset")) {
                recordGroup = "execute";
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!this.captureNativeStats()) {
            XQEDebugLog.err.println(this.getNativeError());
            XQEDebugLog.err.println("Failed to capture native stats. Recording dummy memory stats instead.");
            this.enabled = false;
            return;
        }
        long javaMaxMem = this.runtime.maxMemory() / 1024L;
        long javaTotalMem = this.runtime.totalMemory() / 1024L;
        long javaUsedMem = javaTotalMem - this.runtime.freeMemory() / 1024L;
        StringBuilder output = new StringBuilder();
        output.append(recordGroup).append(COMMA).append(item).append(COMMA);
        output.append(this.virtualSize).append(COMMA).append(this.peakVirtualSize).append(COMMA);
        output.append(this.workingSet).append(COMMA).append(this.peakWorkingSet).append(COMMA);
        output.append(this.privateBytes).append(COMMA).append(this.peakPrivateBytes).append(COMMA);
        output.append(javaUsedMem).append(COMMA).append(javaMaxMem).append(COMMA);
        output.append(javaTotalMem).append(COMMA).append(this.privateBytes - javaTotalMem).append(COMMA);
        output.append(elapsedTime);
        if (!this.bDisableConsoleStats) {
            XQEDebugLog.err.println(output);
        }
        this.memStatsFile.println(output);
        if (javaTotalMem - this.previousJavaMemory > (long)MemoryUtil.getDumpInterval()) {
            MemoryUtil.heapDump();
            this.previousJavaMemory += (long)MemoryUtil.getDumpInterval();
        }
    }

    private synchronized native boolean captureNativeStats();

    private synchronized native String getNativeError();

    private synchronized boolean captureExternalAppStats() {
        boolean status = false;
        try {
            String line;
            if (this.command == null) {
                this.command = "..\\..\\src\\xqe\\dev\\Tools\\stats\\pslist -m " + pid;
            }
            Process process = Runtime.getRuntime().exec(this.command);
            InputStreamReader reader = new InputStreamReader(process.getInputStream());
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                Matcher matcher = this.pattern.matcher(line);
                if (!matcher.matches()) continue;
                this.virtualSize = Long.parseLong(matcher.group(1));
                if (this.peakVirtualSize < this.virtualSize) {
                    this.peakVirtualSize = this.virtualSize;
                }
                this.workingSet = Long.parseLong(matcher.group(2));
                if (this.peakWorkingSet < this.workingSet) {
                    this.peakWorkingSet = this.workingSet;
                }
                this.privateBytes = Long.parseLong(matcher.group(3));
                this.peakPrivateBytes = Long.parseLong(matcher.group(4));
                status = true;
                break;
            }
            in.close();
        }
        catch (IOException e) {
            XQEDebugLog.err.printStackTrace(e);
        }
        return status;
    }
}

