/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.query.engine.SessionContext;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQEFileAppender;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.config.LoggingOverrides;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.context.Context;
import com.cognos.xqe.util.context.ContextTransfer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public final class TraceContext
extends Context {
    public static final String TRACE_ATTRIBUTE_ROLAP_CUBE = "rolapCube";
    public static final String TRACE_ATTRIBUTE_ROLAP_DIMENSION = "rolapDimension";
    public static final String TRACE_ATTRIBUTE_ROLAP_HIERARCHY = "rolapHierarchy";
    public static final String TRACE_ATTRIBUTE_ROLAP_AGGREGATE = "rolapAggregate";
    public static final String TRACE_ATTRIBUTE_SESSION_ID = "sessionId";
    public static final String TRACE_ATTRIBUTE_REQUEST_ID = "requestId";
    private static final AtomicLong CONTEXT_ID_COUNTER = new AtomicLong(0L);
    private long mContextId = -1L;
    private final Map<String, String> mAttributes = new TreeMap<String, String>();
    private XQELogAppender mCustomAppender = null;
    private String mCustomAppenderFilename = null;
    private boolean mManagesCustomAppender = false;
    private static final Map<String, CachedAppender> APPENDER_CACHE = new HashMap<String, CachedAppender>();

    private TraceContext() {
    }

    private TraceContext(long contextId, Map<String, String> attributes, XQELogAppender customAppender) {
        this.mContextId = contextId;
        this.mAttributes.putAll(attributes);
        this.mCustomAppender = customAppender;
    }

    @Override
    protected boolean isTransferable() {
        return true;
    }

    @Override
    protected Context transferableClone() throws UnsupportedOperationException {
        return new TraceContext(this.getContextId(), this.getAttributes(), this.getCustomLogAppender());
    }

    public long getContextId() {
        return this.mContextId;
    }

    public Map<String, String> getAttributes() {
        return this.mAttributes;
    }

    public void addAttribute(String name, String value) {
        this.mAttributes.put(name, value);
    }

    public XQELogAppender getCustomLogAppender() {
        return this.mCustomAppender;
    }

    public void createCustomAppenders(LoggingOverrides overrides, SessionContext sessionContext) {
        if (null == overrides) {
            return;
        }
        if (this.getParentContext() != null) {
            return;
        }
        String appenderFilename = overrides.getCustomAppenderFilename();
        if (null != appenderFilename) {
            this.mCustomAppenderFilename = appenderFilename;
            this.mCustomAppender = TraceContext.getOrCreateCustomAppender(appenderFilename, sessionContext);
            this.mManagesCustomAppender = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XQELogAppender getOrCreateCustomAppender(String filename, SessionContext sessionContext) {
        Map<String, CachedAppender> map = APPENDER_CACHE;
        synchronized (map) {
            CachedAppender cachedAppender = APPENDER_CACHE.get(filename);
            if (null != cachedAppender) {
                cachedAppender.incrementCount();
            } else {
                Parameters params = new Parameters();
                params.addParameter("fileName", filename);
                params.addParameter("includeTimestampInFileName", "true");
                cachedAppender = new CachedAppender(new XQEFileAppender(params));
                APPENDER_CACHE.put(filename, cachedAppender);
                if (sessionContext != null) {
                    sessionContext.registerResource(new AppenderReleaser(filename));
                    cachedAppender.incrementCount();
                }
            }
            return cachedAppender.getAppender();
        }
    }

    @Override
    protected void onEnter() {
        if (-1L == this.mContextId) {
            TraceContext parentContext = this.getParentContext();
            if (null != parentContext) {
                this.mContextId = parentContext.mContextId;
                this.mCustomAppender = parentContext.mCustomAppender;
            } else {
                this.mContextId = CONTEXT_ID_COUNTER.incrementAndGet();
                this.mCustomAppender = null;
            }
        }
    }

    @Override
    protected void onExit() {
        if (this.mManagesCustomAppender) {
            TraceContext.releaseCustomAppender(this.mCustomAppenderFilename);
            this.mCustomAppenderFilename = null;
            this.mManagesCustomAppender = false;
        }
        this.mCustomAppender = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseCustomAppender(String appenderFilename) {
        Map<String, CachedAppender> map = APPENDER_CACHE;
        synchronized (map) {
            CachedAppender cachedAppender = APPENDER_CACHE.get(appenderFilename);
            if (cachedAppender != null && cachedAppender.decrementCount() == 0) {
                cachedAppender.getAppender().commit();
                cachedAppender.getAppender().close();
                APPENDER_CACHE.remove(appenderFilename);
            }
        }
    }

    public static TraceContext enter() {
        TraceContext context = new TraceContext();
        Context.enter(context);
        return context;
    }

    public void exit() {
        this.exitContext(TraceContext.class);
    }

    public static ContextTransfer createTransfer() {
        return Context.createTransfer(TraceContext.class);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TraceContext[id=").append(this.getContextId());
        buffer.append(", attributes=").append(this.mAttributes.toString()).append("]");
        return buffer.toString();
    }

    public static TraceContext get() {
        return TraceContext.getCurrent(TraceContext.class);
    }

    public TraceContext getParentContext() {
        return (TraceContext)this.getNext();
    }

    private static class AppenderReleaser
    implements IReleasable {
        private final String mAppenderFilename;

        AppenderReleaser(String appenderFilename) {
            this.mAppenderFilename = appenderFilename;
        }

        @Override
        public void release() {
            TraceContext.releaseCustomAppender(this.mAppenderFilename);
        }
    }

    private static class CachedAppender {
        private int mCounter;
        XQELogAppender mAppender;

        CachedAppender(XQELogAppender appender) {
            this.mAppender = appender;
            this.mCounter = 1;
        }

        int incrementCount() {
            return ++this.mCounter;
        }

        int decrementCount() {
            return --this.mCounter;
        }

        XQELogAppender getAppender() {
            return this.mAppender;
        }
    }
}

