/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class TraceLogWriter
extends Writer {
    private File file;
    private Writer writer;

    public TraceLogWriter(File logFile) {
        this.file = logFile;
    }

    private void createWriter() {
        try {
            FileOutputStream stream = new FileOutputStream(this.file, this.file.exists());
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
        }
        catch (FileNotFoundException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (UnsupportedEncodingException uee) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)uee);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer == null) {
            this.createWriter();
        }
        this.writer.write(cbuf, off, len);
    }
}

