/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.XQEDebugPrintStream;
import com.cognos.xqe.trace.remote.server.RemoteTraceServer;
import com.cognos.xqe.util.io.MultiOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class XQEDebugLog {
    private static final String XQE_DEBUG_LOGGING = "XQE_DEBUG_LOGGING";
    private static boolean enabled = false;
    public static XQEDebugPrintStream out = null;
    public static XQEDebugPrintStream err = null;

    public static XQEDebugPrintStream newStream(OutputStream s) {
        try {
            return new XQEDebugPrintStream(s, enabled);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static XQEDebugPrintStream newStream(OutputStream s, boolean enable) {
        try {
            return new XQEDebugPrintStream(s, enabled, enable);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private static void initialize() {
        boolean devEnvironment = false;
        Map<Thread, StackTraceElement[]> stackTraceMap = Thread.getAllStackTraces();
        for (StackTraceElement[] st : stackTraceMap.values()) {
            for (int i = 0; i < st.length; ++i) {
                if (st[i].getClassName().startsWith("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner")) {
                    devEnvironment = true;
                    break;
                }
                if (i != st.length - 1 || !st[i].getClassName().startsWith("com.cognos.xqe") || st[i].getClassName().endsWith("DQServer") || st[i].getClassName().endsWith("DynamicCubesAdminTool") || !st[i].getMethodName().equals("main")) continue;
                devEnvironment = true;
            }
            if (!devEnvironment) continue;
            break;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        enabled = devEnvironment || null != config && config.getBooleanProperty("debugLogging[@enabled]", false) || "true".equals(System.getenv(XQE_DEBUG_LOGGING));
        MultiOutputStream outStream = new MultiOutputStream();
        MultiOutputStream errStream = new MultiOutputStream();
        if (null == config || config.getBooleanProperty("debugLogging.console[@enabled]", true)) {
            outStream.addStream(System.out);
            errStream.addStream(System.err);
        }
        if (null != config && config.getBooleanProperty("debugLogging.remote[@enabled]", false)) {
            RemoteTraceServer server = RemoteTraceServer.getInstance();
            outStream.addStream(server.getOutChannel().getOutputStream());
            errStream.addStream(server.getErrChannel().getOutputStream());
        }
        out = XQEDebugLog.newStream(outStream);
        err = XQEDebugLog.newStream(errStream);
    }

    static {
        XQEDebugLog.initialize();
    }
}

