/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.mfw4j.utilities.ThreadSafeDateFormat;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQEFileAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import com.cognos.xqe.trace.message.LogMessage;
import java.io.PrintWriter;

public class XQECSVAppender
extends XQEFileAppender {
    private static final String EMPTY = "";
    private static final String COMMA = ",";
    public static final ThreadSafeDateFormat TIMESTAMP_FORMAT = new ThreadSafeDateFormat("yyyyMMdd,HH,mm,ss,SSS");
    private static final String TITLE = "Component,Group,Level,Thread,Date,Hr,Min,Sec,Ms,Op,Duration,Message";

    public XQECSVAppender(Parameters param) {
        super(param);
    }

    @Override
    protected String getLogFileOpenTag() {
        return TITLE;
    }

    @Override
    protected String getLogFileCloseTag() {
        return EMPTY;
    }

    @Override
    protected String getFileExtension() {
        return ".csv";
    }

    @Override
    protected String formatPrefix(LogEvent event, long duration) {
        StringBuilder sb = new StringBuilder();
        sb.append(event.getComponent()).append(COMMA);
        sb.append(event.getEventGroup()).append(COMMA);
        sb.append(event.getLevel().name()).append(COMMA);
        sb.append(Long.toString(event.getThreadId())).append(COMMA);
        sb.append(TIMESTAMP_FORMAT.format((Object)event.getTimestamp())).append(COMMA);
        sb.append(event.getOp().toString()).append(COMMA);
        if (duration >= 0L) {
            sb.append(duration);
        }
        sb.append(COMMA);
        return sb.toString();
    }

    @Override
    protected String formatSuffix(LogEvent event) {
        return EMPTY;
    }

    @Override
    protected void writeLogMessage(LogMessage msg, PrintWriter output) {
        output.write(34);
        String strMsg = msg.getMessage();
        String result = strMsg.replaceAll("\"", "\"\"");
        output.write(result);
        output.write(34);
    }
}

