/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LoggingConstants;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import com.cognos.xqe.trace.logger.LogEventStack;
import com.cognos.xqe.trace.message.LogMessage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class XQEFileAppender
extends XQELogAppender {
    private static final String CONSTANT_DASH = "-";
    private static final String ARGS_END = "}\" ";
    private static final String DEFAULT_LOG_PATH = "../logs" + File.separator + "XQE" + File.separator;
    private static final long DEFAULT_FLUSH_PERIOD = 100L;
    private static final String LOG_OPEN_TAG = "<log>";
    private static final String LOG_CLOSE_TAG = "</log>";
    private static final String DEFAULT_LOG_FILE = "xqelog";
    public static final String FILE_EXT = ".xml";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String EVENT_END = "</event>";
    private static final String LOG_TO_FILE = "Log to file ";
    public static final String PARAM_INCLUDE_TIMESTAMP_FILENAME = "includeTimestampInFileName";
    public static final String PARAM_INCLUDE_TIMESTAMP = "includeTimestamp";
    public static final String PARAM_ROLL_OVER_SIZE = "rollOverSize";
    public static final String PARAM_INCLUDE_COMPONENT = "includeComponent";
    public static final String PARAM_INCLUDE_LEVEL = "includeLevel";
    public static final String PARAM_INCLUDE_THREAD = "includeThread";
    public static final String PARAM_INCLUDE_OP = "includeOp";
    public static final String PARAM_INCLUDE_ATTRS = "includeAttributes";
    public static final String PARAM_AUTO_FLUSH = "autoFlush";
    public static final String PARAM_FILE_NAME = "fileName";
    public static final String PARAM_DIR = "dir";
    private final LogEventStack perfEvents = new LogEventStack();
    private static final long DEFAULT_XQE_LOG_ROLLOVER_FILE_SIZE_KB = 10000L;
    private static final long DEFAULT_ROLLOVER_CONVERSION_TO_BYTES = 1024L;
    private static long xqeLogRollOverFileSize = 10240000L;
    private LogWriter logWriter = null;
    private File currentXQEServerLog = null;
    private PrintWriter logFile = null;
    private boolean enableLogWriter = false;
    private String loggingDir = DEFAULT_LOG_PATH;
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final Parameters params;
    private boolean initializationFailed = false;
    private boolean testMode = false;
    private boolean logWriterFinishedLogging = false;
    private static final String LAST_LINE_FOR_XQE_LOG = "XQE-LOG-TEST-FINISHED";
    protected boolean includeTimestamp;
    protected boolean includeComponent;
    protected boolean includeLevel;
    protected boolean includeOp;
    protected boolean includeThread;
    protected boolean includeAttributes;

    public XQEFileAppender(Parameters param) {
        super(param);
        this.params = param;
        this.includeTimestamp = this.params.getBoolean(PARAM_INCLUDE_TIMESTAMP, true);
        this.includeComponent = this.params.getBoolean(PARAM_INCLUDE_COMPONENT, true);
        this.includeLevel = this.params.getBoolean(PARAM_INCLUDE_LEVEL, true);
        this.includeOp = this.params.getBoolean(PARAM_INCLUDE_OP, true);
        this.includeThread = this.params.getBoolean(PARAM_INCLUDE_THREAD, true);
        this.includeAttributes = this.params.getBoolean(PARAM_INCLUDE_ATTRS, true);
    }

    private synchronized void createLogFile() {
        if (this.isInitialized || this.initializationFailed) {
            return;
        }
        String fileName = this.params.getString(PARAM_FILE_NAME, DEFAULT_LOG_FILE);
        boolean includeTimestampInFileName = this.params.getBoolean(PARAM_INCLUDE_TIMESTAMP_FILENAME, true);
        xqeLogRollOverFileSize = this.params.getInteger(PARAM_ROLL_OVER_SIZE, 10000L) * 1024L;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String xqeLogsFolder = configuration.getXqeLogsDirectory();
        String xqeLogsFileAppender = configuration.getXqeLogsFileAppender();
        fileName = fileName + xqeLogsFileAppender;
        this.loggingDir = this.params.getString(PARAM_DIR, xqeLogsFolder);
        new File(this.loggingDir).mkdirs();
        long autoFlush = this.params.getInteger(PARAM_AUTO_FLUSH, 100L);
        if (includeTimestampInFileName) {
            SimpleDateFormat format = new SimpleDateFormat("yyMMdd-HHmmssSSS");
            StringBuilder builder = new StringBuilder();
            builder.append(CONSTANT_DASH);
            builder.append(format.format(new Date(System.currentTimeMillis())));
            builder.append(COUNTER.incrementAndGet());
            fileName = fileName + builder.toString();
        }
        this.currentXQEServerLog = new File(this.loggingDir, fileName + this.getFileExtension());
        try {
            this.logFile = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.currentXQEServerLog)), "UTF8"), true);
            this.logFile.println(this.getLogFileOpenTag());
            if (this.logWriter == null && autoFlush > 0L) {
                this.enableLogWriter = true;
                this.logWriter = new LogWriter(autoFlush);
                this.logWriter.start();
            }
            this.isInitialized = true;
        }
        catch (IOException e) {
            System.err.println("Failed to open log file " + this.currentXQEServerLog.getAbsolutePath());
            if (this.logFile != null) {
                this.logFile.close();
            }
            this.isInitialized = false;
            this.initializationFailed = true;
            return;
        }
    }

    @Override
    public void addEvent(LogEvent anEvent) {
        if (!this.isInitialized && !this.initializationFailed) {
            this.createLogFile();
        }
        if (this.isInitialized) {
            if (anEvent.getOp() == OperationEnum.START) {
                this.perfEvents.push(anEvent);
            } else if (anEvent.getOp() == OperationEnum.END) {
                long duration = this.getPerfEventDuration(anEvent);
                anEvent.setDuration(duration);
            }
            if (this.enableLogWriter) {
                super.addEvent(anEvent);
            } else {
                this.logEvent(anEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEvent(LogEvent event) {
        PrintWriter printWriter = this.logFile;
        synchronized (printWriter) {
            if (!event.getFileName().equals("")) {
                this.logToFile(event);
            } else {
                this.logFile.print(this.formatPrefix(event, event.getDuration()));
                this.writeLogMessage(event.getLogMessage(), this.logFile);
                this.logFile.println(this.formatSuffix(event));
            }
        }
        if (this.currentXQEServerLog.length() >= xqeLogRollOverFileSize) {
            this.startNewLogFile();
        }
        if (this.testMode && event.getLogMessage().toString().equals(LAST_LINE_FOR_XQE_LOG)) {
            this.logWriterFinishedLogging = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewLogFile() {
        PrintWriter printWriter = this.logFile;
        synchronized (printWriter) {
            this.logFile.println(this.getLogFileCloseTag());
            this.logFile.flush();
            this.logFile.close();
        }
        this.isInitialized = false;
        this.createLogFile();
    }

    public long getMaxFileSize() {
        return xqeLogRollOverFileSize;
    }

    public void setTestMode(boolean enableTest) {
        this.testMode = enableTest;
    }

    public boolean isWriteFinished() {
        return this.logWriterFinishedLogging;
    }

    public String getLastLoggingLine() {
        return LAST_LINE_FOR_XQE_LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(LogEvent event) {
        File fileLog = new File(this.loggingDir, event.getFileName() + this.getFileExtension());
        this.logFile.print("Log to file \"" + fileLog.getAbsolutePath() + "\"" + ".");
        try (PrintWriter writer = null;){
            writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileLog)), true);
            this.writeLogMessage(event.getLogMessage(), writer);
            writer.flush();
        }
    }

    protected String formatPrefix(LogEvent event, long duration) {
        ArrayList<Object> argsList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("<event ");
        int counter = 0;
        if (this.includeComponent) {
            argsList.add(event.getComponent());
            sb.append("component=\"{");
            sb.append(counter++);
            sb.append(ARGS_END);
        }
        argsList.add(event.getEventGroup());
        sb.append("group=\"{");
        sb.append(counter++);
        sb.append(ARGS_END);
        if (this.includeLevel) {
            sb.append("level=\"{");
            sb.append(counter++);
            sb.append(ARGS_END);
            argsList.add(event.getLevel().name());
        }
        if (this.includeThread) {
            argsList.add(Long.toString(event.getThreadId()));
            sb.append("thread=\"{");
            sb.append(counter++);
            sb.append(ARGS_END);
        }
        if (this.includeTimestamp) {
            sb.append("timestamp=\"{");
            sb.append(counter++);
            sb.append(ARGS_END);
            argsList.add(LoggingConstants.TIMESTAMP_FORMAT.format((Object)event.getTimestamp()));
        }
        if (this.includeOp && event.getOp() != OperationEnum.DEFAULT) {
            argsList.add(event.getOp().toString());
            sb.append("op=\"{");
            sb.append(counter++);
            sb.append(ARGS_END);
            if (duration >= 0L) {
                argsList.add(Long.toString(duration));
                sb.append("duration=\"{");
                sb.append(counter++);
                sb.append(ARGS_END);
            }
        }
        if (this.includeAttributes) {
            this.addContextAttributes(event, argsList, sb, counter);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(">");
        sb.append(CDATA_BEGIN);
        MessageFormat messageFormat = new MessageFormat(sb.toString());
        return messageFormat.format(argsList.toArray(new Object[argsList.size()]));
    }

    protected String formatSuffix(LogEvent event) {
        return "]]></event>";
    }

    private void addContextAttributes(LogEvent event, List<Object> argsList, StringBuilder sb, int counter) {
        for (Map.Entry<String, String> entry : event.getContextAttributes().entrySet()) {
            sb.append(entry.getKey());
            sb.append("=\"{");
            sb.append(counter++);
            sb.append(ARGS_END);
            argsList.add(entry.getValue());
        }
    }

    private long getPerfEventDuration(LogEvent event) {
        LogEvent startEvent;
        long duration = -1L;
        if (event.getOp() == OperationEnum.END && (startEvent = this.perfEvents.pop(event.getThreadId())) != null) {
            duration = event.getTimestamp() - startEvent.getTimestamp();
        }
        return duration;
    }

    @Override
    public void commit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isInitialized) {
            PrintWriter printWriter;
            this.isInitialized = false;
            if (this.enableLogWriter) {
                this.logWriter.deactivate();
                while (this.logWriter.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        printWriter = null;
                    }
                }
            }
            printWriter = this.logFile;
            synchronized (printWriter) {
                this.logFile.println(this.getLogFileCloseTag());
                this.logFile.close();
            }
        }
    }

    protected String getLogFileOpenTag() {
        return LOG_OPEN_TAG;
    }

    protected String getLogFileCloseTag() {
        return LOG_CLOSE_TAG;
    }

    protected String getFileExtension() {
        return FILE_EXT;
    }

    protected void writeLogMessage(LogMessage msg, PrintWriter output) {
        msg.writeMessage(output);
    }

    private final class LogWriter
    extends Thread {
        private boolean isActive;
        private final long flushPeriod;
        private Queue<LogEvent> events;

        private LogWriter(long defaultFlushPeriod) {
            super("logwriter-thread");
            this.isActive = true;
            this.events = new ConcurrentLinkedQueue<LogEvent>();
            this.setDaemon(true);
            this.flushPeriod = defaultFlushPeriod;
        }

        private void deactivate() {
            this.isActive = false;
        }

        @Override
        public void run() {
            while (this.isActive || !XQEFileAppender.this.logEvents.isEmpty()) {
                XQEFileAppender.this.flushEvents(this.events);
                for (LogEvent e : this.events) {
                    XQEFileAppender.this.logEvent(e);
                }
                this.events.clear();
                if (this.flushPeriod <= 0L) continue;
                try {
                    Thread.sleep(this.flushPeriod);
                }
                catch (InterruptedException e) {
                    Iterator iterator = null;
                }
            }
        }
    }
}

