/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.logger.LogEvent;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class XQELogAppender {
    protected boolean isInitialized = false;
    protected final Queue<LogEvent> logEvents = new ConcurrentLinkedQueue<LogEvent>();
    private final Set<ServiceEnumeration> services = new HashSet<ServiceEnumeration>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private String name;

    public XQELogAppender(Parameters params) {
        this.name = params.getString("name", "appender");
    }

    public final String getName() {
        return this.name;
    }

    public void addEvent(LogEvent anEvent) {
        this.logEvents.add(anEvent);
    }

    public final void registerService(ServiceEnumeration e) {
        this.lock.writeLock().lock();
        try {
            this.services.add(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final void deregisterService(ServiceEnumeration e) {
        this.lock.writeLock().lock();
        try {
            this.services.remove((Object)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final boolean isActive() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.services.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void flushEvents(Queue<LogEvent> currentEvents) {
        LogEvent e = this.logEvents.poll();
        while (e != null) {
            currentEvents.add(e);
            e = this.logEvents.poll();
        }
    }

    public String dumpLogEvents() {
        String dump = new String();
        for (LogEvent event : this.logEvents) {
            dump = dump + event.toString() + "\n";
        }
        return dump;
    }

    public abstract void commit();

    public boolean useAppenderIsOn() {
        return false;
    }

    public boolean isOn(String component, String eventGroup, LogLevel level) {
        return false;
    }

    public void close() {
        this.commit();
        this.isInitialized = false;
    }
}

