/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import com.cognos.xqe.util.ExceptionUtil;
import java.util.List;

public class XQEMultiAppender
extends XQELogAppender {
    private final List<XQELogAppender> mAppenders;

    public XQEMultiAppender(List<XQELogAppender> appenders, Parameters param) {
        super(param);
        this.mAppenders = appenders;
    }

    @Override
    public void addEvent(LogEvent anEvent) {
        for (XQELogAppender appender : this.mAppenders) {
            try {
                appender.addEvent(anEvent);
            }
            catch (Exception e) {
                XQEDebugLog.err.println(ExceptionUtil.getStackTrace(e));
            }
        }
    }

    @Override
    public void commit() {
        for (XQELogAppender appender : this.mAppenders) {
            try {
                appender.commit();
            }
            catch (Exception e) {
                XQEDebugLog.err.println(ExceptionUtil.getStackTrace(e));
            }
        }
    }
}

