/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.config;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQEFileAppender;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.appender.XQEMultiAppender;
import com.cognos.xqe.trace.config.CommonsConfigMBean;
import com.cognos.xqe.trace.config.ILoggingConfig;
import com.cognos.xqe.trace.logger.XQELoggerStub;
import com.cognos.xqe.trace.logger.XQELoggerStubKey;
import com.cognos.xqe.util.xml.serializer.XMLElementMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;

public class CommonsConfig
implements ILoggingConfig,
CommonsConfigMBean,
XQEConfigurationListener {
    private static final String NULL_STR = "NULL";
    private static final String CONST_STRING_TRUE = "true";
    private static final String ELEMENT_NAME = "[@name]";
    private static final String ELEMENT_CLASS = "[@class]";
    private static final String ELEMENT_LEVEL = "[@level]";
    private static final String ELEMENT_LOGGER = "[@appender]";
    private static final String ELEMENT_VALUE = "[@value]";
    private static final String ELEMENT_PARAM = "param";
    private static final String EVENT_GROUP_ELEMENT = "eventGroup";
    private static final String DEFAULT_APPENDER = "file";
    private volatile boolean isEnabled = false;
    private volatile String defaultAppender = "";
    private volatile LogLevel defaultLevel = LogLevel.ERROR;
    private volatile XQEConfiguration configuration;
    private final ServiceEnumeration serviceEnum;
    private AtomicBoolean isRegistered = new AtomicBoolean(false);
    private static volatile Map<String, XQELogAppender> appendersMap = new ConcurrentHashMap<String, XQELogAppender>();
    @XMLElementMap(name="LoggerStubs", itemName="LoggerStubEntry", keyName="LoggerKey", valName="LoggerStub")
    private volatile Map<XQELoggerStubKey, XQELoggerStub> loggersMap = new ConcurrentHashMap<XQELoggerStubKey, XQELoggerStub>();

    public CommonsConfig(ServiceEnumeration svc) {
        this.serviceEnum = svc;
        this.load();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config.inStandaloneMode()) {
            this.registerMBean();
        }
    }

    private void registerMBean() {
        try {
            XqeMBeanServer mbs = XqeMBeanServer.getInstance();
            ObjectName name = new ObjectName("com.cognos.xqe:type=Logging,name=" + this.serviceEnum.name());
            mbs.registerMBean(this, name);
        }
        catch (Throwable ex) {
            XQEDebugLog.err.println("JMX for XQE logging is disabled: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public XQELogAppender getDefaultAppender() {
        XQELogAppender appender = this.getAppender(this.defaultAppender);
        if (appender == null && (appender = this.getAppender(DEFAULT_APPENDER)) == null) {
            this.defaultAppender = DEFAULT_APPENDER;
            Parameters params = new Parameters();
            params.addParameter("includeTimestamp", CONST_STRING_TRUE);
            params.addParameter("name", this.defaultAppender);
            appender = new XQEFileAppender(params);
            appender.registerService(this.serviceEnum);
            appendersMap.put(DEFAULT_APPENDER, appender);
        }
        return appender;
    }

    private XQELogAppender getAppender(String appenderName) {
        String[] parts;
        XQELogAppender appender = appendersMap.get(appenderName);
        if (null == appender && (parts = appenderName.split(";")).length > 1) {
            appender = this.createMultiAppender(parts);
        }
        return appender;
    }

    private XQELogAppender createMultiAppender(String[] appenderNames) {
        ArrayList<XQELogAppender> appenderList = new ArrayList<XQELogAppender>(appenderNames.length);
        for (String appenderName : appenderNames) {
            XQELogAppender appender = appendersMap.get(appenderName.trim());
            if (null != appender) {
                appenderList.add(appender);
                continue;
            }
            XQEDebugLog.err.println("Failed to create XQEMultiAppender - unknown appender name: " + appenderName);
        }
        if (appenderList.isEmpty()) {
            return null;
        }
        Parameters params = new Parameters();
        params.addParameter("name", Arrays.toString(appenderNames));
        return new XQEMultiAppender(appenderList, params);
    }

    @Override
    public void commit() {
        for (XQELogAppender appender : appendersMap.values()) {
            appender.commit();
        }
    }

    @Override
    public XQELoggerStub getLoggerStub(XQELoggerStubKey key) {
        if (this.isEnabled) {
            return this.loggersMap.get(key);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void disable() {
        this.isEnabled = false;
    }

    @Override
    public void release() {
        this.disable();
        this.commit();
        for (XQELogAppender appender : appendersMap.values()) {
            appender.deregisterService(this.serviceEnum);
            if (appender.isActive()) continue;
            appender.close();
            appendersMap.remove(appender.getName());
        }
    }

    @Override
    public void reload() {
        this.disable();
        this.commit();
        this.load();
    }

    @Override
    public void load() {
        try {
            this.initConfiguration();
            this.initDefaultProperty();
            if (this.isEnabled) {
                this.initAppenders();
                this.initComponents();
            }
        }
        catch (Throwable e) {
            this.release();
            System.err.println("Following error occurred when loading logging configuration: ");
            e.printStackTrace();
            System.err.println("XQE diagnostic logging is disabled.");
        }
    }

    private void initConfiguration() {
        this.configuration = XQEConfigurationManager.getInstance().getConfiguration(this.serviceEnum);
        if (this.configuration == null) {
            try {
                this.configuration = XQECCLConfigurationAdapter.createDefaultConfigurationForService(this.serviceEnum);
                XQEConfigurationManager.getInstance().add(this.serviceEnum, this.configuration);
                this.configuration.loadParameterAccessCoordinator();
            }
            catch (ConfigException ce) {
                if (XQEMessageKeys.CFG_FileExistError == ce.getMessageKey() && this.serviceEnum == ServiceEnumeration.XQEODP) {
                    return;
                }
                throw ce;
            }
        }
        if (this.isRegistered.compareAndSet(false, true)) {
            this.configuration.registerXQEConfigurationListener(this, XQEConfiguration.ConfigEnum.XQE_DIAGNOSTIC_LOGGING_CONFIG);
        }
    }

    private void initDefaultProperty() {
        if (this.configuration != null) {
            this.defaultLevel = LogLevel.valueOf(this.configuration.getDefaultLoggingLevel().toUpperCase());
            this.defaultAppender = this.configuration.getDefaultLoggingAppender();
            this.isEnabled = this.configuration.getLoggingEnabled();
        } else {
            this.defaultLevel = LogLevel.ERROR;
            this.defaultAppender = DEFAULT_APPENDER;
            this.isEnabled = true;
        }
    }

    private void initAppenders() {
        XQESubConfiguration subConfiguration;
        if (this.configuration != null && (subConfiguration = this.configuration.getLoggingAppenders()) != null) {
            while (subConfiguration.hasNext()) {
                subConfiguration.next();
                XQELogAppender appender = null;
                String appenderName = subConfiguration.getString(ELEMENT_NAME, "");
                String appenderClass = subConfiguration.getString(ELEMENT_CLASS, "");
                if (appenderName.equals("") && appenderClass.equals("")) continue;
                XQESubConfiguration paramConfig = subConfiguration.getChildren(ELEMENT_PARAM);
                Parameters param = new Parameters();
                param.addParameter("name", appenderName);
                while (paramConfig.hasNext()) {
                    paramConfig.next();
                    String name = paramConfig.getString(ELEMENT_NAME, "");
                    if (name.equals("")) continue;
                    String value = paramConfig.getString(ELEMENT_VALUE, "");
                    param.addParameter(name, value);
                }
                appender = appendersMap.get(appenderName);
                if (appender == null) {
                    try {
                        appender = this.createAppender(appenderClass, param);
                        appendersMap.put(appenderName, appender);
                    }
                    catch (Exception e) {
                        System.err.println("Skip appender " + appenderName + " due to initialization error.");
                        e.printStackTrace();
                        appender = null;
                    }
                }
                if (appender == null) continue;
                appender.registerService(this.serviceEnum);
            }
        }
    }

    private void initComponents() {
        XQESubConfiguration compConfiguration;
        this.addLoggerStub(this.defaultAppender, "UNSPECIFIED", "Unspecified", this.defaultLevel);
        if (this.configuration != null && (compConfiguration = this.configuration.getLoggingComponents()) != null) {
            while (compConfiguration.hasNext()) {
                compConfiguration.next();
                String compName = compConfiguration.getString(ELEMENT_NAME, "UNSPECIFIED");
                String compLevel = compConfiguration.getString(ELEMENT_LEVEL, this.defaultLevel.name());
                String compAppender = compConfiguration.getString(ELEMENT_LOGGER, this.defaultAppender);
                this.addLoggerStub(compAppender, compName, "Unspecified", compLevel);
                XQESubConfiguration groupConfiguration = compConfiguration.getChildren(EVENT_GROUP_ELEMENT);
                if (groupConfiguration == null) continue;
                while (groupConfiguration.hasNext()) {
                    groupConfiguration.next();
                    String groupName = groupConfiguration.getString(ELEMENT_NAME, "Unspecified");
                    String groupLevel = groupConfiguration.getString(ELEMENT_LEVEL, compLevel);
                    String groupAppender = groupConfiguration.getString(ELEMENT_LOGGER, compAppender);
                    this.addLoggerStub(groupAppender, compName, groupName, groupLevel);
                }
            }
        }
    }

    private XQELogAppender createAppender(String className, Parameters params) throws Exception {
        Class<?> clazz = Class.forName(className);
        Class[] paramList = new Class[]{Parameters.class};
        Object[] argList = new Object[]{params};
        return (XQELogAppender)clazz.getDeclaredConstructor(paramList).newInstance(argList);
    }

    private XQELogAppender addLoggerStub(String appenderName, String compName, String groupName, LogLevel logLevel) {
        XQELogAppender appender = this.getAppender(appenderName);
        if (appender != null) {
            XQELoggerStubKey key = new XQELoggerStubKey(compName, groupName);
            XQELoggerStub value = new XQELoggerStub(appender, compName, groupName, logLevel);
            this.loggersMap.put(key, value);
        }
        return appender;
    }

    private XQELogAppender addLoggerStub(String appenderName, String compName, String groupName, String logLevel) {
        LogLevel level = null;
        try {
            if (logLevel == null) {
                throw new Exception();
            }
            level = LogLevel.valueOf(logLevel.toUpperCase());
        }
        catch (Throwable e) {
            System.out.println("LogLevel " + logLevel + " is invalid.");
            level = LogLevel.NONE;
        }
        return this.addLoggerStub(appenderName, compName, groupName, level);
    }

    @Override
    public void configurationChanged(XQEConfigurationEvent e) {
        if (e.isBeforeUpdate() || e.getType() != 20) {
            return;
        }
        XQELog.reload(this.serviceEnum);
    }

    @Override
    public ServiceEnumeration getService() {
        return this.serviceEnum;
    }

    @Override
    public void setAppender(String component, String eventGroup, String appender) {
        if (component != null && eventGroup != null && appender != null) {
            if (eventGroup.length() == 0) {
                eventGroup = "Unspecified";
            }
            XQELoggerStubKey key = new XQELoggerStubKey(component, eventGroup);
            XQELoggerStub stub = this.loggersMap.get(key);
            XQELogAppender logAppender = appendersMap.get(appender);
            if (logAppender == null) {
                logAppender = appendersMap.get(this.defaultAppender);
            }
            if (stub == null) {
                stub = new XQELoggerStub(logAppender, component, eventGroup, this.defaultLevel);
                this.loggersMap.put(key, stub);
            } else {
                stub.setAppender(logAppender);
            }
        }
    }

    @Override
    public void setLogLevel(String component, String eventGroup, String level) {
        if (component != null && eventGroup != null && level != null) {
            if (eventGroup.length() == 0) {
                eventGroup = "Unspecified";
            }
            XQELoggerStubKey key = new XQELoggerStubKey(component, eventGroup);
            XQELoggerStub stub = this.loggersMap.get(key);
            LogLevel logLevel = LogLevel.valueOf(level.toUpperCase());
            if (stub == null) {
                stub = new XQELoggerStub(appendersMap.get(this.defaultAppender), component, eventGroup, logLevel);
                this.loggersMap.put(key, stub);
            } else {
                stub.setLogLevel(logLevel);
            }
        }
    }

    @Override
    public void reloadConfig() {
        XQELog.reloadLoggers(this.serviceEnum);
    }

    @Override
    public String getAppender(String component, String eventGroup) {
        if (component != null && eventGroup != null) {
            XQELogger logger;
            if (eventGroup.length() == 0) {
                eventGroup = "Unspecified";
            }
            if ((logger = XQELog.getLogger(this.serviceEnum, component, eventGroup, LogLevel.NONE)).getAppender() != null) {
                return logger.getAppender().getName();
            }
            return NULL_STR;
        }
        return NULL_STR;
    }

    @Override
    public String getLogLevel(String component, String eventGroup) {
        if (component != null && eventGroup != null) {
            if (eventGroup.length() == 0) {
                eventGroup = "Unspecified";
            }
            XQELogger logger = XQELog.getLogger(this.serviceEnum, component, eventGroup, LogLevel.NONE);
            return logger.getLogLevel().toString();
        }
        return NULL_STR;
    }
}

