/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.logger;

import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.LoggingConstants;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.message.LogMessage;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class LogEvent {
    private final long threadId;
    private final String camSessionId;
    private final String component;
    private final String eventGroup;
    private final LogLevel level;
    private final OperationEnum op;
    private final LogMessage message;
    private long timestamp;
    private String fileName;
    private long duration;
    private Map<String, String> resolvedAttributes = new TreeMap<String, String>();
    public static final long NULL_DURATION = -1L;

    public LogEvent(long theThreadId, String theCAMSessionId, LogLevel theLevel, String theComp, String aEventGroup, OperationEnum anOp, LogMessage aMessage) {
        this.threadId = theThreadId;
        this.camSessionId = theCAMSessionId;
        this.level = theLevel;
        this.component = theComp;
        this.eventGroup = aEventGroup;
        this.op = anOp;
        this.message = aMessage;
        this.timestamp = System.currentTimeMillis();
        this.fileName = "";
        this.duration = -1L;
        this.resolveContextAttributes();
    }

    public LogEvent(long theThreadId, String theCAMSessionId, LogLevel theLevel, String theComp, String anEventGroup, LogMessage aMessage) {
        this(theThreadId, theCAMSessionId, theLevel, theComp, anEventGroup, OperationEnum.DEFAULT, aMessage);
    }

    public long getThreadId() {
        return this.threadId;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getComponent() {
        return this.component;
    }

    public String getEventGroup() {
        return this.eventGroup;
    }

    public LogMessage getLogMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setFileName(String theFileName) {
        this.fileName = theFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setDuration(long theDuration) {
        this.duration = theDuration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void clearTimestamp() {
        this.timestamp = 0L;
    }

    public OperationEnum getOp() {
        return this.op;
    }

    public String getCAMSessionId() {
        return this.camSessionId;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LoggingConstants.TIMESTAMP_FORMAT.format(new Date(this.timestamp))).append("\tTID: ").append(this.threadId).append("\tSID: ").append(this.camSessionId).append("\tCOM: ").append(this.component).append("\tEvG: ").append(this.eventGroup);
        for (Map.Entry<String, String> entry : this.getContextAttributes().entrySet()) {
            buffer.append('\t').append(entry.getKey()).append('=').append(entry.getValue());
        }
        buffer.append("\tMSG: ").append(this.message);
        return buffer.toString();
    }

    private void resolveContextAttributes() {
        TraceContext context = TraceContext.get();
        if (null != context) {
            this.resolvedAttributes.put("contextId", Long.toString(context.getContextId()));
            while (context != null) {
                Map<String, String> attributes = context.getAttributes();
                if (!attributes.isEmpty()) {
                    for (Map.Entry<String, String> entry : attributes.entrySet()) {
                        if (this.resolvedAttributes.containsKey(entry.getKey())) continue;
                        this.resolvedAttributes.put(entry.getKey(), entry.getValue());
                    }
                }
                context = context.getParentContext();
            }
        }
    }

    public Map<String, String> getContextAttributes() {
        return this.resolvedAttributes;
    }
}

