/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.logger;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.appender.XQESLF4JAppender;
import com.cognos.xqe.trace.config.LoggingOverrides;
import com.cognos.xqe.trace.logger.LogEvent;
import com.cognos.xqe.trace.message.LogMessage;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.serializer.XMLElement;

@XMLElement(name="XQELogger")
public class XQELoggerImpl {
    private static final String STR_SEP = ", ";
    private final XQELogAppender appender;
    private XQESLF4JAppender slf4jAppender = null;
    @XMLElement(name="Service")
    private ServiceEnumeration service;
    @XMLElement(name="Component")
    private String component;
    @XMLElement(name="EventGroup")
    private String eventGroup;
    @XMLElement(name="LogLevel", callMethod="name")
    private LogLevel logLevel;
    @XMLElement(name="Default", callMethod="name")
    private final LogLevel defaultLevel;
    private boolean testMode = false;
    @XMLElement(name="NeedReload")
    private volatile boolean needReload = false;
    @XMLElement(name="IsClosed")
    private volatile boolean isClosed = false;
    public static final String CONFIG_USE_SLF4J_LOGGING = "general.useSlf4jLogging[@enabled]";

    public XQELoggerImpl(XQELogAppender anAppender, ServiceEnumeration aService, String aComponent, String anEventGroup, LogLevel aLevel, LogLevel defaultLogLevel) {
        this.service = aService;
        this.appender = anAppender;
        this.component = aComponent;
        this.eventGroup = anEventGroup;
        this.logLevel = aLevel;
        this.defaultLevel = defaultLogLevel;
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (xqeConfig != null && xqeConfig.getBooleanProperty(CONFIG_USE_SLF4J_LOGGING, true)) {
            Parameters params = new Parameters();
            params.addParameter("name", "slf4j");
            this.slf4jAppender = new XQESLF4JAppender(params);
        }
    }

    public boolean isOn() {
        boolean useOverride = true;
        boolean considerSlf4jLogger = true;
        return this.isOn(this.defaultLevel, useOverride, considerSlf4jLogger);
    }

    public boolean isOn(LogLevel aLogLevel) {
        boolean useOverride = true;
        boolean considerSlf4jLogger = true;
        return this.isOn(aLogLevel, useOverride, considerSlf4jLogger);
    }

    public boolean isOn(LogLevel aLogLevel, boolean useOverride, boolean considerSlf4jLogger) {
        if (this.isClosed) {
            return false;
        }
        IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env != null) {
            Boolean isOverrideOn;
            LoggingOverrides overrides;
            MultiRequestContext multiRequestContext = env.getMultiRequestContextNoThrow();
            if (multiRequestContext != null) {
                LogLevel dqaLogLevel;
                if (multiRequestContext.getDQALoggingLevel() == null) {
                    QueryEngineLoggingUtils.overrideXqeLoggingLevel(env.getRequestEnvironment());
                }
                if ((dqaLogLevel = multiRequestContext.getDQALoggingLevel()) != null && dqaLogLevel != LogLevel.NONE) {
                    return aLogLevel.compareTo(dqaLogLevel) >= 0;
                }
            }
            if (useOverride && null != (overrides = this.getLoggingOverrides(env)) && Boolean.TRUE.equals(isOverrideOn = this.isOverrideOn(overrides, aLogLevel))) {
                return true;
            }
        }
        if (considerSlf4jLogger && this.slf4jAppender != null && this.slf4jAppender.isOn(this.component, this.eventGroup, aLogLevel)) {
            return true;
        }
        if (this.appender != null && this.appender.useAppenderIsOn()) {
            return this.appender.isOn(this.component, this.eventGroup, aLogLevel);
        }
        if (LogLevel.NONE == aLogLevel || LogLevel.NONE == this.logLevel) {
            return false;
        }
        return aLogLevel.compareTo(this.logLevel) >= 0;
    }

    protected LoggingOverrides getLoggingOverrides(IExecutionEnvironment env) {
        if (env != null) {
            Object reqEnv = env.getRequestEnvironment();
            return reqEnv.getLoggingOverrides();
        }
        return null;
    }

    protected Boolean isOverrideOn(LoggingOverrides overrides, LogLevel aLogLevel) {
        LogLevel overriddenLevel;
        if (null != overrides && null != (overriddenLevel = overrides.getLogLevel(this.component, this.eventGroup))) {
            if (LogLevel.NONE == aLogLevel || LogLevel.NONE == overriddenLevel) {
                return false;
            }
            return aLogLevel.compareTo(overriddenLevel) >= 0;
        }
        return null;
    }

    public void log(LogLevel aLogLevel, OperationEnum anOp, LogMessage message, String fileName, long duration) {
        XQELogAppender customAppender;
        TraceContext ctx;
        IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
        LoggingOverrides overrides = this.getLoggingOverrides(env);
        boolean useOverride = false;
        boolean considerSlf4jLogger = false;
        boolean isOnGlobal = this.isOn(aLogLevel, useOverride, considerSlf4jLogger);
        Boolean isOnOverride = this.isOverrideOn(overrides, aLogLevel);
        boolean hasCustomAppenders = null != overrides && overrides.hasCustomAppenders();
        boolean isOnSlf4jLogger = false;
        if (this.slf4jAppender != null) {
            isOnSlf4jLogger = this.slf4jAppender.isOn(this.component, this.eventGroup, aLogLevel);
        }
        LogEvent event = null;
        if (isOnGlobal || Boolean.TRUE.equals(isOnOverride) || isOnSlf4jLogger) {
            String camSessionId = "";
            if (!this.testMode && env != null && env.getRequestEnvironment() != null) {
                camSessionId = env.getRequestEnvironment().getCAMUserSessionID();
            }
            event = new LogEvent(Thread.currentThread().getId(), camSessionId, aLogLevel, this.component, this.eventGroup, anOp, message);
            event.setFileName(fileName);
            if (duration != -1L) {
                event.setDuration(duration);
            }
            if (this.testMode) {
                event.clearTimestamp();
            }
        } else {
            return;
        }
        if (isOnGlobal) {
            this.appender.addEvent(event);
        }
        if (isOnSlf4jLogger) {
            this.slf4jAppender.addEvent(event);
        }
        if (hasCustomAppenders && (Boolean.TRUE.equals(isOnOverride) || isOnGlobal && isOnOverride == null) && null != (ctx = TraceContext.get()) && null != (customAppender = ctx.getCustomLogAppender())) {
            customAppender.addEvent(event);
        }
    }

    public void close() {
        this.isClosed = true;
    }

    protected static String getRequestId() {
        String reqID = "";
        IExecutionEnvironment env = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env != null && env.getRequestEnvironment() != null) {
            reqID = env.getRequestEnvironment().getRequestID();
        }
        return reqID;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public LogLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public XQELogAppender getAppender() {
        return this.appender;
    }

    public void setTestMode(boolean flag) {
        this.testMode = flag;
    }

    protected boolean getTestMode() {
        return this.testMode;
    }

    public ServiceEnumeration getService() {
        return this.service;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String aComponent) {
        this.component = aComponent;
    }

    public String getEventGroup() {
        return this.eventGroup;
    }

    public void setEventGroup(String anEventGroup) {
        this.eventGroup = anEventGroup;
    }

    public void setReloadFlag() {
        this.needReload = true;
    }

    public boolean needToReload() {
        return this.needReload;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.service.name()).append(STR_SEP).append(this.component).append(STR_SEP).append(this.eventGroup).append(STR_SEP).append(this.logLevel.name()).append(STR_SEP).append(this.defaultLevel.name());
        return buf.toString();
    }
}

