/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.logger;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class XQELoggerKey
implements Comparable<XQELoggerKey> {
    private static final String STR_SEP = ", ";
    @XMLElement(name="Service")
    private final ServiceEnumeration service;
    @XMLElement(name="Component")
    private final String component;
    @XMLElement(name="EventGroup")
    private final String eventGroup;
    @XMLElement(name="DefaultLevel")
    private final LogLevel defaultLevel;
    private int cachedHashCode = Integer.MIN_VALUE;

    public XQELoggerKey(ServiceEnumeration aService, String aComponent, String aEventGroup, LogLevel defaultLogLevel) {
        this.service = aService;
        this.component = aComponent;
        this.eventGroup = aEventGroup;
        this.defaultLevel = defaultLogLevel;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof XQELoggerKey)) {
            return false;
        }
        XQELoggerKey otherKey = (XQELoggerKey)other;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append((Object)this.service, (Object)otherKey.service);
        eb.append((Object)this.component, (Object)otherKey.component);
        eb.append((Object)this.eventGroup, (Object)otherKey.eventGroup);
        eb.append((Object)this.defaultLevel, (Object)otherKey.defaultLevel);
        return eb.isEquals();
    }

    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.service);
        hcb.append((Object)this.component);
        hcb.append((Object)this.eventGroup);
        hcb.append((Object)this.defaultLevel);
        this.cachedHashCode = hcb.toHashCode();
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            this.cachedHashCode = 0;
        }
        return this.cachedHashCode;
    }

    @Override
    public int compareTo(XQELoggerKey other) {
        if (null == other) {
            return -1;
        }
        if (!(other instanceof XQELoggerKey)) {
            return -1;
        }
        XQELoggerKey otherKey = other;
        CompareToBuilder ctb = new CompareToBuilder();
        ctb.append((Object)this.service, (Object)otherKey.service);
        ctb.append((Object)this.component, (Object)otherKey.component);
        ctb.append((Object)this.eventGroup, (Object)otherKey.eventGroup);
        ctb.append((Object)this.defaultLevel, (Object)otherKey.defaultLevel);
        return ctb.toComparison();
    }

    public String toString() {
        return this.service.name() + STR_SEP + this.component + STR_SEP + this.eventGroup + STR_SEP + this.defaultLevel.name();
    }

    public String getComponent() {
        return this.component;
    }

    public ServiceEnumeration getService() {
        return this.service;
    }

    public String getEventGroup() {
        return this.eventGroup;
    }

    public LogLevel getDefaultLevel() {
        return this.defaultLevel;
    }
}

