/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.message;

import com.cognos.xqe.trace.message.LogMessage;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ThrowableMessage
implements LogMessage {
    private Throwable exception;
    private String message;
    private String renderedMessage;

    public ThrowableMessage(Throwable aException) {
        this(null, aException);
    }

    public ThrowableMessage(String aMessage, Throwable aException) {
        this.message = aMessage;
        this.exception = aException;
    }

    public Throwable getThrowable() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        if (this.renderedMessage == null) {
            StringBuilder strBuilder = new StringBuilder();
            if (this.message != null) {
                strBuilder.append(this.message);
            }
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            this.exception.printStackTrace(printWriter);
            printWriter.close();
            strBuilder.append(strWriter.toString());
            this.renderedMessage = strBuilder.toString();
        }
        return this.renderedMessage;
    }

    @Override
    public void writeMessage(PrintWriter writer) {
        if (this.message != null) {
            writer.print(this.message);
        }
        if (ThrowableMessage.validateChainedExceptions(this.exception)) {
            this.exception.printStackTrace(writer);
            return;
        }
        int stackDepth = 0;
        ThrowableMessage.writeStackElements(writer, this.exception, stackDepth);
    }

    private static void writeStackElements(PrintWriter writer, Throwable exception, int stackDepth) {
        String whiteSpace = "";
        for (int i = 0; i < stackDepth; ++i) {
            whiteSpace = whiteSpace + "  ";
        }
        writer.println();
        String s1 = exception.toString();
        writer.write(whiteSpace + s1);
        writer.println();
        StackTraceElement[] stackTraceElements = exception.getStackTrace();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement ste = stackTraceElements[i];
            String element = ste.toString();
            writer.write(whiteSpace + element);
            writer.println();
        }
        if (exception.equals(exception.getCause())) {
            writer.write(whiteSpace + "*** Self Referencing Exception ***");
            writer.println();
            writer.write(s1);
            writer.println();
            return;
        }
        if (stackDepth < 50 && exception.getCause() != null) {
            ThrowableMessage.writeStackElements(writer, exception.getCause(), stackDepth + 1);
        }
    }

    private static boolean validateChainedExceptions(Throwable exception) {
        if (exception.equals(exception.getCause())) {
            return false;
        }
        if (exception.getCause() != null) {
            return ThrowableMessage.validateChainedExceptions(exception.getCause());
        }
        return true;
    }
}

