/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.remote.client;

import com.cognos.xqe.util.ExceptionUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class TraceClientMain {
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORTNUM = 9555;
    private String hostName = "localhost";
    private int portNum = 9555;
    private Socket clientSocket = null;
    private volatile boolean running = true;

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--host".equals(args[i])) {
                if (args.length == ++i) {
                    this.error("Missing hostname.");
                }
                this.hostName = args[i];
                continue;
            }
            if ("--port".equals(args[i])) {
                if (args.length == ++i) {
                    this.error("Missing port number.");
                }
                try {
                    this.portNum = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    this.error("Invalid port number: " + args[i]);
                }
                continue;
            }
            this.error("Unsupported command-line argument: " + args[i]);
        }
    }

    private void run() {
        System.out.println();
        System.out.println("# Connecting to trace server " + this.hostName + " on port " + this.portNum + " ...");
        try {
            this.clientSocket = new Socket(this.hostName, this.portNum);
            System.out.println("# Connected.");
            System.out.println("# Hit return to exit.");
            System.out.println();
            Thread clientThread = new Thread(){

                @Override
                public void run() {
                    TraceClientMain.this.clientLoop();
                }
            };
            clientThread.start();
            System.in.read();
            this.running = false;
            this.clientSocket.close();
            System.out.println("# Client Disconnected.");
        }
        catch (IOException ex) {
            this.error(ExceptionUtil.getStackTrace(ex));
        }
    }

    private void clientLoop() {
        try {
            InputStream sockStream = this.clientSocket.getInputStream();
            DataInputStream dataStream = new DataInputStream(sockStream);
            byte[] readBuffer = new byte[4096];
            while (this.running) {
                int channelNameLen = dataStream.readInt();
                if (channelNameLen < 0) {
                    this.running = false;
                    break;
                }
                dataStream.readFully(readBuffer, 0, channelNameLen);
                String channelName = new String(readBuffer, 0, channelNameLen);
                int textLen = dataStream.readInt();
                dataStream.readFully(readBuffer, 0, textLen);
                String text = new String(readBuffer, 0, textLen);
                if ("out".equals(channelName)) {
                    System.out.print(text);
                    continue;
                }
                if (!"err".equals(channelName)) continue;
                System.err.print(text);
            }
        }
        catch (IOException ex) {
            return;
        }
    }

    private void error(String message) {
        System.err.println(message);
        System.err.flush();
        System.exit(-1);
    }

    public static void main(String[] args) {
        TraceClientMain main = new TraceClientMain();
        main.parseArgs(args);
        main.run();
    }
}

