/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.remote.server;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.remote.server.ITraceChannel;
import com.cognos.xqe.util.SingletonHelper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class RemoteTraceServer {
    private static final int DEFAULT_PORT = 9555;
    private static final int SO_TIMEOUT = 1000;
    private static final String LOG_EVENT_GROUP = "RemoteTraceServer";
    private static final SingletonHelper<RemoteTraceServer> SINGLETON_HELPER = new SingletonHelper<RemoteTraceServer>(){

        @Override
        protected RemoteTraceServer newInstance() {
            return new RemoteTraceServer();
        }

        @Override
        protected void initializeImpl(RemoteTraceServer theInstance) {
        }

        @Override
        protected void releaseImpl(RemoteTraceServer theInstance) {
            theInstance.stopServer();
        }
    };
    private volatile boolean serverStarted = false;
    private volatile boolean serverStopped = true;
    private Thread listenerThread = null;
    private ServerSocket listenerSocket = null;
    private final List<Socket> clientSockets = new ArrayList<Socket>();
    private final Object clientSocketsLock = new Object();
    private final Set<Socket> noddyClients = Collections.synchronizedSet(new HashSet());
    private final TraceChannelImpl outChannel = new TraceChannelImpl("out");
    private final TraceChannelImpl errChannel = new TraceChannelImpl("err");
    private XQELogger logger = null;

    private RemoteTraceServer() {
    }

    public ITraceChannel getOutChannel() {
        return this.outChannel;
    }

    public ITraceChannel getErrChannel() {
        return this.errChannel;
    }

    public synchronized void startServer() {
        if (!this.serverStopped) {
            throw new IllegalStateException();
        }
        if (null == System.getProperty("enableTraceServer")) {
            return;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", LOG_EVENT_GROUP, LogLevel.INFO);
        if (config.getBooleanProperty("remoteTraceServer[@enabled]", false)) {
            int port = config.getIntProperty("remoteTraceServer[@port]", 9555);
            this.logger.log(LogLevel.INFO, "Starting server on port " + port);
            try {
                this.listenerSocket = new ServerSocket(port);
                this.listenerSocket.setSoTimeout(1000);
            }
            catch (IOException ex) {
                this.logger.log(LogLevel.ERROR, (Throwable)ex);
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
            this.listenerThread = new Thread(){

                @Override
                public void run() {
                    RemoteTraceServer.this.serverLoop();
                }
            };
            this.serverStopped = false;
            this.serverStarted = true;
            this.listenerThread.start();
        }
    }

    public synchronized void stopServer() {
        if (!this.serverStarted) {
            return;
        }
        this.logger.log(LogLevel.INFO, "Stopping server");
        this.serverStarted = false;
        while (!this.serverStopped) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        this.logger.log(LogLevel.INFO, "Server stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverLoop() {
        Object object;
        while (this.serverStarted) {
            Object object2;
            object = this.clientSocketsLock;
            synchronized (object) {
                object2 = this.noddyClients;
                synchronized (object2) {
                    for (Socket client : this.noddyClients) {
                        this.logger.log(LogLevel.TRACE, "Removing noddy client: " + client.getRemoteSocketAddress().toString());
                        this.clientSockets.remove(client);
                    }
                    this.noddyClients.clear();
                }
                Iterator<Socket> clientIter = this.clientSockets.iterator();
                while (clientIter.hasNext()) {
                    Socket client = clientIter.next();
                    if (client.isConnected()) continue;
                    this.logger.log(LogLevel.TRACE, "Removing disconnected client: " + client.getRemoteSocketAddress().toString());
                    clientIter.remove();
                }
            }
            try {
                Socket client = this.listenerSocket.accept();
                this.logger.log(LogLevel.INFO, "Accepted client connection from " + client.getRemoteSocketAddress().toString());
                object2 = this.clientSocketsLock;
                synchronized (object2) {
                    this.clientSockets.add(client);
                }
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ex) {
                this.logger.log(LogLevel.ERROR, (Throwable)ex);
                break;
            }
        }
        this.logger.log(LogLevel.INFO, "Closing server socket.");
        if (!this.listenerSocket.isClosed()) {
            try {
                this.listenerSocket.close();
            }
            catch (IOException ex) {
                this.logger.log(LogLevel.WARN, (Throwable)ex);
            }
        }
        this.logger.log(LogLevel.INFO, "Closing client sockets.");
        this.noddyClients.clear();
        object = this.clientSocketsLock;
        synchronized (object) {
            for (Socket client : this.clientSockets) {
                try {
                    if (client.isClosed()) continue;
                    client.close();
                }
                catch (IOException ex) {
                    this.logger.log(LogLevel.WARN, (Throwable)ex);
                }
            }
            this.clientSockets.clear();
        }
        object = this;
        synchronized (object) {
            this.serverStarted = false;
            this.serverStopped = true;
            this.notify();
        }
    }

    public static RemoteTraceServer getInstance() {
        return SINGLETON_HELPER.getInstance();
    }

    public static void releaseInstance() {
        SINGLETON_HELPER.releaseInstance();
    }

    private static final class ChannelOutputStream
    extends OutputStream {
        private static final int BUFFER_SIZE = 1024;
        private static final int BYTE_MASK = 255;
        private final TraceChannelImpl channel;
        private final ByteBuffer buffer = ByteBuffer.allocate(1024);

        ChannelOutputStream(TraceChannelImpl theChannel) {
            this.channel = theChannel;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.flush();
            }
            this.buffer.put((byte)(b & 0xFF));
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            super.write(b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
        }

        @Override
        public synchronized void flush() throws IOException {
            this.buffer.flip();
            this.channel.send(this.buffer);
            this.buffer.clear();
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private final class TraceChannelImpl
    implements ITraceChannel {
        private final String name;
        private final byte[] encodedName;
        private final ChannelOutputStream stream = new ChannelOutputStream(this);

        TraceChannelImpl(String theName) {
            this.name = theName;
            try {
                this.encodedName = theName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(ByteBuffer buffer) {
            if (!RemoteTraceServer.this.serverStarted) {
                return;
            }
            buffer.mark();
            Object object = RemoteTraceServer.this.clientSocketsLock;
            synchronized (object) {
                for (Socket client : RemoteTraceServer.this.clientSockets) {
                    this.sendToClient(client, buffer);
                    buffer.reset();
                }
            }
        }

        private void sendToClient(Socket client, ByteBuffer buffer) {
            if (!client.isConnected() || client.isOutputShutdown()) {
                RemoteTraceServer.this.logger.log(LogLevel.WARN, "Marking invalid client for removal: " + client.getRemoteSocketAddress().toString());
                RemoteTraceServer.this.noddyClients.add(client);
                return;
            }
            try {
                DataOutputStream dataStream = new DataOutputStream(client.getOutputStream());
                dataStream.writeInt(this.encodedName.length);
                dataStream.write(this.encodedName);
                dataStream.writeInt(buffer.remaining());
                dataStream.write(buffer.array(), buffer.position(), buffer.remaining());
            }
            catch (IOException ex) {
                RemoteTraceServer.this.logger.log(LogLevel.WARN, "Client error from " + client.getRemoteSocketAddress().toString() + ": ", (Throwable)ex);
                RemoteTraceServer.this.noddyClients.add(client);
            }
        }
    }
}

