/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class AddCustomPropertySortItem
extends Transformation {
    private static final String SORT_PREFIX = "SorT_";

    public AddCustomPropertySortItem() {
        this.mName = "Add data item for custom member property to do sort by value.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{101056};
        this.mMode = QTEAbstractTransformation.Mode.INDEXED;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5SortItem item = (V5SortItem)node;
        String refDataItemName = item.getRefDataItem();
        V5Query query = qrd.getV5Query();
        V5Selection selection = query.getV5Selection();
        V5DataItem dataItem = selection.getDataItemByRefName(refDataItemName);
        V5BoundDataItemReference ref = (V5BoundDataItemReference)dataItem.getChild(0);
        V5DataItem dataItemOrg = ref.getRefDataItem();
        refDataItemName = SORT_PREFIX + refDataItemName;
        V5DataItem dataItemSort = (V5DataItem)nodeFactory.deepCopyNode(dataItemOrg);
        dataItemSort.setNameProperty(refDataItemName);
        dataItemSort.setPropPreserveMetadata(Boolean.FALSE);
        dataItemOrg.getParent().addChild(dataItemSort);
        V5DataItem dataItemRefSort = (V5DataItem)nodeFactory.deepCopyNode(dataItem);
        dataItemRefSort.setNameProperty(refDataItemName);
        dataItem.getParent().addChild(dataItemRefSort);
        ref = (V5BoundDataItemReference)dataItemRefSort.getChild(0);
        ref.setRefDataItem(dataItemSort);
        V5Query subQuery = (V5Query)dataItemSort.getAncestorOfType(101006);
        String newName = UniqueNameGenerator.createUniqueName(subQuery.getV5QueryName(), refDataItemName);
        ref.setIdentifier(newName);
        item.setPropertyValue("refDataItem", refDataItemName);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundDataItemReference ref;
        V5DataItem dataItemOrg;
        V5DataItem dataItem;
        XQETrace trace = environment.getTrace();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5Query query = null;
        if (qrd != null) {
            query = qrd.getV5Query();
        }
        if (query == null || !query.getBooleanPropertyValue("isDecomposed", false).booleanValue()) {
            this.traceQueryCondition(false, "Sorting item is not in decomposed query.", trace);
            return false;
        }
        V5SortItem item = (V5SortItem)node;
        String refDataItem = item.getRefDataItem();
        V5Selection selection = query.getV5Selection();
        if (!selection.getAutoSummary() && (dataItem = selection.getDataItemByRefName(refDataItem)).getChild(0).getType() == 201060 && (dataItemOrg = (ref = (V5BoundDataItemReference)dataItem.getChild(0)).getRefDataItem()).getPropPreserveMetadata().booleanValue()) {
            this.traceQueryCondition(true, "Sorting item is member custom property with preserved metadata.", trace);
            return true;
        }
        this.traceQueryCondition(false, "Sorting item is not member custom property with preserved metadata.", trace);
        return false;
    }
}

