/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.MoveReportAggregatedItemsToMainQuery;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class AddMUNDataItemForDistinct
extends Transformation {
    private static final String MUN_PREFIX = "MUN_";

    public AddMUNDataItemForDistinct() {
        this.mName = "Add MUN data item for distinct operation.";
        this.mPassNumbers = new int[]{14};
        this.mTypes = new int[]{101006};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        V5Selection selection = query.getV5Selection();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode[] dataItems = selection.getChildrenOfType(101003);
        V5Query subQuery = MoveReportAggregatedItemsToMainQuery.getSubQuery(query, environment);
        String subQueryName = subQuery.getV5QueryName();
        IXQEQueryNode[] olapDataItems = subQuery.getDescendantsOfType(101003, false);
        for (IXQEQueryNode current : dataItems) {
            V5DataItem currentDI = (V5DataItem)current;
            V5DataItem di = this.findReferencedDataItem(currentDI, olapDataItems);
            if (di == null) continue;
            V5DataItem diMUN = (V5DataItem)nodeFactory.deepCopyNode(di);
            di.getParent().addChild(diMUN);
            diMUN.setNameProperty(MUN_PREFIX + di.getNameProperty());
            V5RoleValueFunction roleValueFn = (V5RoleValueFunction)nodeFactory.createNode(201098);
            V5LiteralValue propertyName = (V5LiteralValue)nodeFactory.createNode(201026);
            propertyName.setDataType(DataTypeFactory.getVarcharType("_memberUniqueName".length()));
            propertyName.setValue("_memberUniqueName");
            roleValueFn.addChild(propertyName, 0);
            diMUN.getChild(0).insertParent(roleValueFn);
            V5DataItem diGroup = (V5DataItem)nodeFactory.createNode(101003);
            diGroup.setNameProperty(MUN_PREFIX + currentDI.getNameProperty());
            diGroup.setAggregateProperty("none");
            diGroup.setRollupAggregateProperty("none");
            selection.addChild(diGroup);
            String newName = UniqueNameGenerator.createUniqueName(subQueryName, diMUN.getNameProperty());
            diGroup.setOriginalDistinctItem(currentDI.getNameProperty());
            V5BoundDataItemReference newNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
            newNode.setIdentifier(newName);
            newNode.setRefDataItem(diMUN);
            newNode.setIsQueryRefItem();
            diGroup.addChild(newNode);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        boolean distinct = query.getDistinct();
        if (!distinct) {
            this.traceQueryCondition(false, "Extra MUN item is required for distinct query only.", trace);
            return false;
        }
        V5Query subQuery = MoveReportAggregatedItemsToMainQuery.getSubQuery(query, environment);
        if (subQuery != null && !subQuery.isTabular()) {
            V5Selection selection = query.getV5Selection();
            IXQEQueryNode[] dataItems = selection.getChildrenOfType(101003);
            IXQEQueryNode[] olapDataItems = subQuery.getDescendantsOfType(101003, false);
            for (IXQEQueryNode current : dataItems) {
                V5DataItem currentDI = (V5DataItem)current;
                V5DataItem di = this.findReferencedDataItem(currentDI, olapDataItems);
                if (di == null) continue;
                this.traceQueryCondition(true, "Tabular query on top of OLAP contains data item that require MUN comparison.", trace);
                return true;
            }
            this.traceQueryCondition(false, "Tabular query on top of OLAP does not contain data item that require MUN comparison", trace);
            return false;
        }
        this.traceQueryCondition(false, "Query is not tabular on top of OLAP.", trace);
        return false;
    }

    V5DataItem findReferencedDataItem(V5DataItem node, IXQEQueryNode[] olapDataItems) {
        IXQEQueryNode item = node.getChild(0);
        if (item.getType() != 201060) {
            return null;
        }
        if (!node.getAggregateProperty().equals("none")) {
            return null;
        }
        String[] parts = ((V5BoundDataItemReference)item).getNameParts();
        if (parts == null || parts.length == 0) {
            return null;
        }
        String name = parts[parts.length - 1];
        for (IXQEQueryNode current : olapDataItems) {
            IDataType dt;
            V5DataItem di = (V5DataItem)current;
            if (!name.equals(di.getNameProperty()) || (dt = di.getDataType()) == null || dt.getSubType() != DataSubType.METADATATYPE || dt == MemberType.MEMBERTYPE) continue;
            return di;
        }
        return null;
    }
}

