/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;

public class CleanupV5Queries
extends Transformation {
    public static final String PROPERTY_CLEANUP = "cleanup";

    public CleanupV5Queries() {
        this.mName = "Remove V5Query Node if not refereneced by QRD.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] queries;
        for (IXQEQueryNode query : queries = node.getDescendantsOfType(101006, false)) {
            IXQEQueryNode[] qrds;
            String queryName = (String)query.getPropertyValue("name");
            IXQEQueryNode querySet = query.getParent();
            if (querySet.getType() != 101002 || (qrds = querySet.getChildrenOfType(101055)).length == 0) continue;
            boolean queryIsReferencedByQRD = false;
            for (IXQEQueryNode qrd : qrds) {
                V5QueryResultDefinition q = (V5QueryResultDefinition)qrd;
                String refQuery = q.getRefQueryProperty();
                if (!refQuery.equals(queryName)) continue;
                queryIsReferencedByQRD = true;
            }
            if (queryIsReferencedByQRD) continue;
            query.detach();
        }
        node.setPropertyValue(PROPERTY_CLEANUP, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Object property = node.getPropertyValue(PROPERTY_CLEANUP);
        if (property != null && ((Boolean)property).booleanValue()) {
            return false;
        }
        return node.getParent() == null;
    }
}

