/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5FilterFunction;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class DecomposeConditionOnScalarFunction
extends Transformation {
    private int[] scalarTypes = new int[]{201042};

    public DecomposeConditionOnScalarFunction() {
        this.mName = "Scalar condition Logical Decomposition.";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{201066};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode conditionNode;
        V5IsNullExpression nullExp;
        V5FilterFunction filterFn = (V5FilterFunction)node;
        if (this.referencesDataItemNotSupportedByOlap(filterFn)) {
            this.deReferenceDataItemNotSupportedByOlap(filterFn, environment);
        }
        if ((nullExp = this.getIsNotNULLNode(conditionNode = filterFn.getChild(1))) == null) {
            nullExp = this.getIsNULLNode(conditionNode);
        }
        this.decomposeScalarFnForIsNotNull(nullExp, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (this.referencesDataItemNotSupportedByOlap(node) || this.containsFunctionNotSupportedByOlap(node)) {
            IXQEQueryNode conditionNode = node.getChild(1);
            if (this.getIsNotNULLNode(conditionNode) != null) {
                status = true;
            } else if (this.getIsNULLNode(conditionNode) != null) {
                status = true;
            }
        }
        if (status) {
            this.traceQueryCondition(status, "The decompose condition on Scalar function will be applied.", trace);
        }
        return status;
    }

    boolean containsFunctionNotSupportedByOlap(IXQEQueryNode node) {
        boolean bRet = false;
        List<IXQEQueryNode> genericFunctions = node.getDescendantsOfTypesOrdered(this.scalarTypes, true);
        for (IXQEQueryNode genericFunction : genericFunctions) {
            int scaFctType = ((V5GenericFunction)genericFunction).getSubType();
            switch (scaFctType) {
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 18: 
                case 20: 
                case 21: {
                    bRet = true;
                    break;
                }
            }
        }
        return bRet;
    }

    boolean referencesDataItemNotSupportedByOlap(IXQEQueryNode node) {
        List<IXQEQueryNode> items = node.getDescendantsOfTypeOrdered(201060, false);
        for (IXQEQueryNode item : items) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)item;
            V5DataItem dataItem = dataItemRef.getRefDataItem();
            if (dataItem == null || !this.containsFunctionNotSupportedByOlap(dataItem)) continue;
            return true;
        }
        return false;
    }

    V5IsNullExpression getIsNotNULLNode(IXQEQueryNode conditionNode) {
        V5IsNullExpression nodeToReturn = null;
        if (conditionNode.getType() == 201003 && ((V5LogicalExpression)conditionNode).getSubType() == 2 && conditionNode.getNumberChildren() > 0 && conditionNode.getChild(0).getType() == 201010) {
            nodeToReturn = (V5IsNullExpression)conditionNode.getChild(0);
        }
        return nodeToReturn;
    }

    V5IsNullExpression getIsNULLNode(IXQEQueryNode conditionNode) {
        V5IsNullExpression nodeToReturn = null;
        if (conditionNode.getNumberChildren() > 0 && conditionNode.getType() == 201010) {
            nodeToReturn = (V5IsNullExpression)conditionNode;
        }
        return nodeToReturn;
    }

    void deReferenceDataItemNotSupportedByOlap(V5FilterFunction filterFn, PlanningEnvironment environment) {
        IXQEQueryNode referredItem;
        IXQEQueryNode unsupportedOLAPFn = this.getNonSupportedOLAPDataItem(filterFn);
        if (unsupportedOLAPFn != null && (referredItem = this.getRefferedToDataItems(unsupportedOLAPFn)) != null) {
            IXQEQueryNode parent = unsupportedOLAPFn.getParent();
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            parent.exchangeChildNode(unsupportedOLAPFn, nodeFactory.deepCopyNode(referredItem));
        }
    }

    IXQEQueryNode getRefferedToDataItems(IXQEQueryNode node) {
        IXQEQueryNode refferedToDataItem = node;
        if (node.getType() == 201060) {
            refferedToDataItem = ((V5BoundDataItemReference)node).getRefDataItem();
        }
        return refferedToDataItem;
    }

    IXQEQueryNode getNonSupportedOLAPDataItem(V5FilterFunction filterFn) {
        V5BoundDataItemReference refferedByDataItem = null;
        IXQEQueryNode logicalExp = filterFn.getChild(1);
        V5BoundDataItemReference dataItem = (V5BoundDataItemReference)logicalExp.getFirstDescendantOfTypeOrdered(201060, false);
        if (dataItem != null) {
            refferedByDataItem = dataItem;
        }
        return refferedByDataItem;
    }

    void replaceExpWithExpandedExp(IXQEQueryNode parentLogicalExp, List<IXQEQueryNode> funcParams, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5LogicalExpression newCondition = (V5LogicalExpression)nodeFactory.createNode(201003);
        newCondition.setSubType(1);
        IXQEQueryNode firstChild = nodeFactory.createNode(parentLogicalExp.getType());
        firstChild.addChild(nodeFactory.deepCopyNode(funcParams.get(0)));
        newCondition.addChild(firstChild);
        IXQEQueryNode secondChild = nodeFactory.createNode(parentLogicalExp.getType());
        secondChild.addChild(nodeFactory.deepCopyNode(funcParams.get(1)));
        newCondition.addChild(secondChild);
        V5Expression exp = (V5Expression)nodeFactory.createNode(101004);
        exp.addChild(newCondition);
        parentLogicalExp.exchange(newCondition);
    }

    void decomposeScalarFnForIsNotNull(V5IsNullExpression nullExp, PlanningEnvironment environment) {
        V5GenericFunction scalarFn = (V5GenericFunction)nullExp.getFirstDescendantOfTypeOrdered(201042, false);
        List<IXQEQueryNode> scalarFnParams = this.getParamsOfScalarFn(scalarFn);
        this.replaceExpWithExpandedExp(nullExp, scalarFnParams, environment);
    }

    List<IXQEQueryNode> getParamsOfScalarFn(V5GenericFunction scalarFn) {
        ArrayList<IXQEQueryNode> paramNodes = new ArrayList<IXQEQueryNode>();
        if (scalarFn != null && scalarFn.getNumberChildren() == 2) {
            paramNodes.add(scalarFn.getChild(0));
            paramNodes.add(scalarFn.getChild(1));
        }
        return paramNodes;
    }
}

