/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ErrorCellListUpdate;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.listupdate.XV5ErrorCellUpdateRule;
import com.cognos.xqe.runtree.v5.listupdate.XV5ListColumnValueSpec;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5QueryTypeCheck;
import com.cognos.xqe.transformation.v5exptomdxexp.binding.ReplaceProjectedPropertyBoundMultiPartIdentifier;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class InsertErrorCellListUpdateDecorationRelOlap
extends Transformation {
    public static final String PROP_BOOLEAN_IS_DECOMPOSED = "isDecomposed";

    public InsertErrorCellListUpdateDecorationRelOlap() {
        this.mName = "Insert Error Cell in List summaries.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101053, 101052};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        V5QueryResultDefinition queryResultDefinition = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        String refQuery = queryResultDefinition.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        IXQEQueryNode[] v5DataItemRefs = node.getChildren();
        for (int idx = 0; idx < v5DataItemRefs.length; ++idx) {
            V5BoundDataItemReference v5BoundDataItemRef2;
            V5DataItemRef v5DataItemRef = (V5DataItemRef)v5DataItemRefs[idx];
            V5DataItem v5DataItem = v5Query.getV5Selection().getDataItemByRefName(v5DataItemRef.getDataItemRefProperty());
            V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(v5DataItem.getRollupAggregateProperty());
            IXQEQueryNode v5DataItemChild = v5DataItem.getChild(0);
            if (v5DataItemChild.getType() == 101003 && rollupAggregate == V5RollupAggregateEnum.CALCULATED) {
                V5DataItem tabularItem = (V5DataItem)v5DataItemChild;
                rollupAggregate = V5RollupAggregateEnum.valueOfV5String(tabularItem.getRollupAggregateProperty());
            }
            IXQEQueryNode valueExpression = null;
            if (v5DataItemChild.getType() == 201014) {
                valueExpression = v5DataItemChild;
            } else if (v5DataItemChild.getType() == 201060) {
                v5BoundDataItemRef2 = (V5BoundDataItemReference)v5DataItemChild;
                V5DataItem diOriginal = v5BoundDataItemRef2.getRefDataItem();
                valueExpression = diOriginal.getChild(0);
            } else if (v5DataItemChild.getType() == 201026) {
                valueExpression = v5DataItemChild;
            } else if ((v5DataItemChild = v5DataItemChild.getChild(0)).getType() == 201060) {
                v5BoundDataItemRef2 = (V5BoundDataItemReference)v5DataItemChild;
                V5DataItem diOriginal = v5BoundDataItemRef2.getRefDataItem();
                valueExpression = diOriginal.getChild(0);
            } else {
                valueExpression = v5DataItemChild;
            }
            if (!this.isErrorCellRequired(valueExpression, rollupAggregate)) continue;
            V5ErrorCellListUpdate listUpdateNode = null;
            int descendentType = 601027;
            IXQEQueryNode[] nodeListUpdate = rsapiDataset.getDescendantsOfType(descendentType, false);
            if (nodeListUpdate.length == 0) {
                listUpdateNode = (V5ErrorCellListUpdate)nodeFactory.createNode(601027);
                if (queryResultDefinition == null || !V5QueryTypeCheck.isRelationalQuery(queryResultDefinition)) throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidChildNode, "InsertErrorCellListUpdateDecorationRelOlap");
                rsapiDataset.addChild(listUpdateNode);
            } else {
                listUpdateNode = (V5ErrorCellListUpdate)nodeListUpdate[0];
            }
            if (rollupAggregate == V5RollupAggregateEnum.NONE) {
                v5DataItem.setErrorCell();
            }
            int rowSetId = rowset.getRowsetId();
            int edgeOrdinal = rowset.getEdge().getPositionalOrdinal();
            String v5Name = "ProjectedSummaryWithRollupAggregateNone";
            XV5ListColumnValueSpec nodeCellSpec = new XV5ListColumnValueSpec(edgeOrdinal, rowSetId, idx, v5Name);
            XV5ErrorCellUpdateRule cellUpdateRule = new XV5ErrorCellUpdateRule(nodeCellSpec);
            listUpdateNode.addCellUpdateRule(cellUpdateRule);
            node.setPropertyValue("ProjectedSummaryWithRollupAggregateNone", "true");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        Object hasPropertySet = node.getPropertyValue("ProjectedSummaryWithRollupAggregateNone");
        if (hasPropertySet == null) {
            V5QueryResultDefinition queryResultDefinition = (V5QueryResultDefinition)node.getAncestorOfType(101055);
            String refQuery = queryResultDefinition.getRefQueryProperty();
            V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
            V5Query v5Query = v5QuerySet.getV5Query(refQuery);
            if (!v5Query.getBooleanPropertyValue(PROP_BOOLEAN_IS_DECOMPOSED, false).booleanValue()) {
                this.traceNodeCondition(false, "This node is not within a RELATIONAL query type (rel over olap).", trace);
                status = false;
                return status;
            }
            IXQEQueryNode[] v5DataItemRefs = node.getChildren();
            for (int idx = 0; idx < v5DataItemRefs.length; ++idx) {
                V5DataItemRef v5DataItemRef = (V5DataItemRef)v5DataItemRefs[idx];
                V5DataItem v5DataItem = v5Query.getV5Selection().getDataItemByRefName(v5DataItemRef.getDataItemRefProperty());
                V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(v5DataItem.getRollupAggregateProperty());
                IXQEQueryNode v5DataItemChild = v5DataItem.getChild(0);
                if (v5DataItemChild.getType() == 101003 && rollupAggregate == V5RollupAggregateEnum.CALCULATED) {
                    V5DataItem tabularItem = (V5DataItem)v5DataItemChild;
                    rollupAggregate = V5RollupAggregateEnum.valueOfV5String(tabularItem.getRollupAggregateProperty());
                }
                IXQEQueryNode valueExpression = null;
                if (v5DataItemChild.getType() == 201014) {
                    valueExpression = v5DataItemChild;
                } else if (v5DataItemChild.getType() == 201060) {
                    V5BoundDataItemReference v5BoundDataItemRef2 = (V5BoundDataItemReference)v5DataItemChild;
                    V5DataItem diOriginal = v5BoundDataItemRef2.getRefDataItem();
                    valueExpression = diOriginal.getChild(0);
                } else {
                    valueExpression = v5DataItemChild.getType() == 201026 ? v5DataItemChild : ((v5DataItemChild = v5DataItemChild.getChild(0)).getType() == 201060 ? v5DataItemChild : v5DataItemChild);
                }
                if (this.isErrorCellRequired(valueExpression, rollupAggregate)) {
                    status = true;
                    int aSeverity = 1;
                    environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ErrorCellForFooterOrHeaderSummaries));
                    this.traceNodeCondition(true, "This node will insert decoration rule for forcing Error cell.", trace);
                    break;
                }
                this.traceNodeCondition(false, "Decoration node to force Error cell is not required.", trace);
                status = false;
            }
        }
        return status;
    }

    private boolean isMeasureExpression(IXQEQueryNode valueExpression) {
        return valueExpression.isOfCategory(201120) && ((V5SimpleNode)valueExpression).getHierarchyInfo().projectsMeasures();
    }

    private boolean isErrorCellRequired(IXQEQueryNode valueExpression, V5RollupAggregateEnum rollupAggregate) {
        IMetadata metaData;
        if (valueExpression.getType() == 201116 && (metaData = ((V5BoundModelIdentifier)valueExpression).getMetadata()) != null && ReplaceProjectedPropertyBoundMultiPartIdentifier.isValidPropertyQueryItem(metaData)) {
            return false;
        }
        boolean errorCell = false;
        if (V5ExpressionCheck.isSetExpression(valueExpression)) {
            if (rollupAggregate != V5RollupAggregateEnum.COUNT && rollupAggregate != V5RollupAggregateEnum.COUNT_DISTINCT) {
                errorCell = true;
            }
        } else if (rollupAggregate == V5RollupAggregateEnum.NONE || rollupAggregate == V5RollupAggregateEnum.CALCULATED && this.isMeasureExpression(valueExpression) || rollupAggregate == V5RollupAggregateEnum.COUNT && V5ToCogMDXUtilities.isNumericValueExpression(valueExpression) && this.isMeasureExpression(valueExpression)) {
            errorCell = true;
        }
        return errorCell;
    }
}

