/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ErrorCellListUpdate;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.listupdate.XV5ErrorCellUpdateRule;
import com.cognos.xqe.runtree.v5.listupdate.XV5ListColumnValueSpec;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class InsertErrorCellListUpdateDecorationUnknownAggregate
extends Transformation {
    public static final String PROP_BOOLEAN_IS_DECOMPOSED = "isDecomposed";

    public InsertErrorCellListUpdateDecorationUnknownAggregate() {
        this.mName = "Insert Error Cell for data items with unknown aggregate.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101051};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getParent().getPropertyValue("RSAPIEdgeRowset");
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        V5Query v5Query = qrd.getV5Query();
        RSAPIDataset rsapiDataset = (RSAPIDataset)qrd.getAncestorOfType(401005);
        int nodeLocalProcessingType = 601027;
        IXQEQueryNode[] nodeListUpdate = rsapiDataset.getDescendantsOfType(nodeLocalProcessingType, false);
        V5ErrorCellListUpdate listUpdateNode = null;
        if (nodeListUpdate.length == 0) {
            listUpdateNode = (V5ErrorCellListUpdate)nodeFactory.createNode(601027);
            rsapiDataset.addChild(listUpdateNode);
        } else {
            listUpdateNode = (V5ErrorCellListUpdate)nodeListUpdate[0];
        }
        IXQEQueryNode[] refDIs = node.getChildrenOfType(101015);
        int rowSetId = rowset.getRowsetId();
        int edgeOrdinal = rowset.getEdge().getPositionalOrdinal();
        String v5Name = "UnknownAggregate";
        for (int i = 0; i < refDIs.length; ++i) {
            V5DataItemRef ref = (V5DataItemRef)refDIs[i];
            V5DataItem item = v5Query.getV5Selection().getDataItemByRefName(ref.getDataItemRefProperty());
            if (this.canAggregateLocally(item)) continue;
            XV5ListColumnValueSpec nodeCellSpec = new XV5ListColumnValueSpec(edgeOrdinal, rowSetId, i, v5Name);
            XV5ErrorCellUpdateRule cellUpdateRule = new XV5ErrorCellUpdateRule(nodeCellSpec);
            listUpdateNode.addCellUpdateRule(cellUpdateRule);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ErrorCellForUnkownAggregate, item.getNameProperty()));
            environment.setTreeHasBeenModified();
        }
    }

    private boolean canAggregateLocally(V5DataItem item) {
        return !item.getRollupAggregateProperty().equals("calculated") || item.getChild(0).getType() != 201060;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] refDIs;
        XQETrace trace = environment.getTrace();
        V5QuerySet qSet = (V5QuerySet)node.getAncestorOfType(101002);
        if (qSet.isMultidimensionalSubquery()) {
            this.traceNodeCondition(false, "Crosstab subquery.", trace);
            return false;
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node.getAncestorOfType(101055);
        if (qrd == null) {
            this.traceNodeCondition(false, "Crosstab over relational set operation.", trace);
            return false;
        }
        V5Query v5Query = qrd.getV5Query();
        if (!v5Query.isTabular() || !v5Query.getBooleanPropertyValue(PROP_BOOLEAN_IS_DECOMPOSED, false).booleanValue()) {
            this.traceNodeCondition(false, "This node is not within a decomposed relational query over olap.", trace);
            return false;
        }
        if (!v5Query.getV5Selection().getAutoSummary()) {
            this.traceQueryCondition(false, "Query is not auto summarized.", trace);
            return false;
        }
        for (IXQEQueryNode current : refDIs = node.getChildrenOfTypeOrdered(101015)) {
            V5DataItemRef ref = (V5DataItemRef)current;
            V5DataItem item = v5Query.getV5Selection().getDataItemByRefName(ref.getDataItemRefProperty());
            if (this.canAggregateLocally(item)) continue;
            this.traceQueryCondition(true, "Unknow aggregation within auto summarized query cannot be calculated locally.", trace);
            return true;
        }
        this.traceQueryCondition(false, "All aggregations can be done locally.", trace);
        return false;
    }
}

