/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.HashSet;
import java.util.Set;

public class NormalizeSubQueryRefs
extends Transformation {
    public static final String PROP_NORMALIZE_SUBQUERYREF_IS_DONE = "NormalizeSubQueryRef";
    public static final String PROP_QUERYREF_FROMFILTER = "queryReferencedFromFilter";

    public NormalizeSubQueryRefs() {
        this.mName = "Normalize sub-query references.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101006};
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        Object isDone = query.getPropertyValue(PROP_NORMALIZE_SUBQUERYREF_IS_DONE);
        if (isDone != null && ((Boolean)isDone).booleanValue()) {
            return false;
        }
        boolean state = false;
        V5Source source = query.getV5Source();
        IXQEQueryNode[] dataItemRefs = query.getDescendantsOfType(201060, false);
        if (dataItemRefs.length == 0) {
            this.traceQueryCondition(state, "No data items referencing queries.", trace);
            return state;
        }
        HashSet<String> qRefsFromDataItems = new HashSet<String>();
        for (IXQEQueryNode iter : dataItemRefs) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)iter;
            if (!dataItemRef.isQueryRefItem()) continue;
            String qRefs = dataItemRef.getNameParts()[0];
            qRefsFromDataItems.add(qRefs);
        }
        if (qRefsFromDataItems.size() == 0) {
            this.traceQueryCondition(state, "No query refs by data items.", trace);
            return state;
        }
        Set<String> qRefsFromSource = source.getReferencedQueries();
        if (qRefsFromSource == null || qRefsFromSource.size() == 0) {
            state = true;
            this.traceQueryCondition(state, "Source does not have query references that data item query references need.", trace);
            return state;
        }
        boolean sourceHasAllQueryRefsFromDataItems = true;
        for (String qRefFromDataItem : qRefsFromDataItems) {
            if (qRefsFromSource.contains(qRefFromDataItem)) continue;
            sourceHasAllQueryRefsFromDataItems = false;
            break;
        }
        return !sourceHasAllQueryRefsFromDataItems;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItemRefs;
        V5Query query = (V5Query)node;
        V5Source source = query.getV5Source();
        for (IXQEQueryNode iter : dataItemRefs = query.getDescendantsOfType(201060, false)) {
            V5Query refQuery;
            V5QuerySet querySet;
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)iter;
            if (!dataItemRef.isQueryRefItem()) continue;
            String queryName = dataItemRef.getNameParts()[0];
            source.addReferencedQuery(queryName);
            if (dataItemRef.getAncestorOfType(101008) == null || (querySet = (V5QuerySet)query.getAncestorOfType(101002)) == null || (refQuery = querySet.getV5Query(queryName)) == null) continue;
            refQuery.setPropertyValue(PROP_QUERYREF_FROMFILTER, true);
        }
        node.setPropertyValue(PROP_NORMALIZE_SUBQUERYREF_IS_DONE, Boolean.TRUE);
    }
}

