/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class NormalizeV5ValueExpression
extends Transformation {
    public NormalizeV5ValueExpression(int[] passNumbers) {
        this.mName = "V5 Value Expression Normalization.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201014};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueExpression exp = (V5ValueExpression)node;
        exp.setSubType(0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        V5ValueExpression exp = (V5ValueExpression)node;
        boolean bl = status = exp.getSubType() == 2 && (this.isStringOperand(exp.getChild(0)) || this.isStringOperand(exp.getChild(1)));
        if (status) {
            this.traceNodeCondition(status, "The value expression will be normalized.", trace);
        }
        return status;
    }

    private boolean isStringOperand(IXQEQueryNode node) {
        IDataType dataType = null;
        if (node instanceof V5BoundDataItemReference) {
            dataType = this.getDataType((V5BoundDataItemReference)node);
        } else if (node instanceof V5SimpleNode) {
            dataType = ((V5SimpleNode)node).getDataType();
        } else if (node instanceof V5DataItem) {
            dataType = ((V5DataItem)node).getDataType();
        } else if (node instanceof V5Expression) {
            dataType = ((V5Expression)node).getDataType();
        } else if (node instanceof RQPDataItemRef) {
            return this.isStringOperand(((RQPDataItemRef)node).getReferencedItem().getChild(0));
        }
        if (dataType == null) {
            return false;
        }
        return dataType.isTextType() || dataType.isClob();
    }

    private IDataType getDataType(V5BoundDataItemReference item) {
        String aggregate;
        V5GenericFunction fn;
        IDataType result = null;
        IXQEQueryNode parent = item.getParent();
        if (!(parent instanceof V5ValueExpression) || ((V5ValueExpression)parent).getSubType() != 2) {
            return result;
        }
        IXQEQueryNode[] operands = parent.getChildren();
        IXQEQueryNode other = null;
        other = item == operands[0] ? operands[1] : operands[0];
        if (other.getType() == 201042 && ((fn = (V5GenericFunction)other).getDataType().getSubType() == DataSubType.VARIANTTYPE || fn.getDataType().getSubType() == DataSubType.UNKNOWN) && ((aggregate = item.getRefDataItem().getAggregateProperty()).equals("none") || aggregate.equals("maximum") || aggregate.equals("minimum"))) {
            result = item.getDataType();
        }
        return result;
    }
}

