/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class RefineAutomaticTabularLocalRolap
extends Transformation {
    public RefineAutomaticTabularLocalRolap() {
        this.mName = "Refine dataItem rollupAggregate Automatic settings";
        this.mPassNumbers = new int[]{16};
        this.mTypes = new int[]{101003};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String automaticRefined = this.resolveAutomaticRollupAggregateForRelOverOlap(node, environment);
        V5DataItem v5DataItem = (V5DataItem)node;
        String rollupAggregate = v5DataItem.getRollupAggregateProperty();
        String aggregate = v5DataItem.getAggregateProperty();
        if (rollupAggregate != null && rollupAggregate.compareTo("automatic") == 0) {
            v5DataItem.setRollupAggregateProperty(automaticRefined);
        }
        if (aggregate != null && aggregate.compareTo("automatic") == 0) {
            if (automaticRefined.equals("none") && !v5DataItem.getRollupAggregateProperty().equals("none")) {
                v5DataItem.setAggregateProperty("calculated");
            } else {
                v5DataItem.setAggregateProperty(automaticRefined);
            }
        }
    }

    private String resolveAutomaticRollupAggregateForRelOverOlap(IXQEQueryNode node, PlanningEnvironment environment) {
        if (this.containsV5SummaryFunction(node) || this.containsIfThenElseOrCase(node)) {
            return "calculated";
        }
        if (this.hasTabularItemsOnTopOfOlap(node)) {
            IXQEQueryNode[] tabularItems = node.getDescendantsOfType(201060, false);
            V5BoundDataItemReference tabularItem = (V5BoundDataItemReference)tabularItems[0];
            return this.aggregateAccordingToOriginalOlapDI(tabularItem);
        }
        if (this.hasReferenceToDataItemWithRollupAggregateDiffThanNone(node)) {
            return this.aggregateAccordingToDIRollup(node);
        }
        return "none";
    }

    private boolean containsV5SummaryFunction(IXQEQueryNode node) {
        return node.getDescendantsOfCategory(201124, false).size() > 0;
    }

    private boolean containsIfThenElseOrCase(IXQEQueryNode node) {
        int[] types = new int[]{201017, 201018};
        IXQEQueryNode[] ifThenElseOrCaseExpressions = node.getDescendantsOfTypes(types, false);
        return ifThenElseOrCaseExpressions.length != 0;
    }

    private boolean hasReferenceToDataItemWithRollupAggregateDiffThanNone(IXQEQueryNode node) {
        int[] types = new int[]{201060};
        IXQEQueryNode[] references = node.getDescendantsOfTypes(types, false);
        boolean ret = false;
        for (IXQEQueryNode reference : references) {
            V5DataItem dataItemRef = null;
            V5BoundDataItemReference identifier = (V5BoundDataItemReference)reference;
            dataItemRef = identifier.getRefDataItem();
            if (dataItemRef == null) continue;
            String rollupAggregate = dataItemRef.getRollupAggregateProperty();
            ret = ret || rollupAggregate != null && !rollupAggregate.equals("none");
        }
        return ret;
    }

    private String aggregateAccordingToDIRollup(IXQEQueryNode node) {
        int[] types = new int[]{201060};
        IXQEQueryNode[] references = node.getDescendantsOfTypes(types, false);
        String rollupAggregate = null;
        V5BoundDataItemReference identifier = (V5BoundDataItemReference)references[0];
        V5DataItem dataItemRef = identifier.getRefDataItem();
        if (dataItemRef != null) {
            rollupAggregate = dataItemRef.getRollupAggregateProperty();
        }
        return rollupAggregate;
    }

    private boolean hasCalculationOrMeasureWithDefinedRegularAggregateOrImplicitMeasure(IXQEQueryNode node) {
        IXQEQueryNode[] modelReferences;
        int[] types = new int[]{201116};
        for (IXQEQueryNode modelReference : modelReferences = node.getDescendantsOfTypes(types, false)) {
            IQueryItem queryItem;
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)modelReference;
            if (identifier.isCalculationWithDefinedRegularAggregate()) {
                return true;
            }
            String regularAggregateName = identifier.getRegularAggregate();
            if (regularAggregateName != null && identifier.isMeasure() && !regularAggregateName.equals("unsupported")) {
                return true;
            }
            if (MetadataType.isMeasureDimension(identifier.getMetadata())) {
                return true;
            }
            if (identifier.getMetadata().getObjectType() != MetadataType.QUERY_ITEM || !(queryItem = (IQueryItem)identifier.getMetadata()).isFact()) continue;
            return true;
        }
        return false;
    }

    private boolean hasTabularItemsOnTopOfOlap(IXQEQueryNode node) {
        int[] types = new int[]{201060};
        IXQEQueryNode[] v5DataItemReferences = node.getDescendantsOfTypes(types, false);
        boolean tabItemsOnTopOfOlap = false;
        for (IXQEQueryNode v5DataItemReference : v5DataItemReferences) {
            V5BoundDataItemReference v5DIRef = (V5BoundDataItemReference)v5DataItemReference;
            if (!v5DIRef.isQueryRefItem()) continue;
            tabItemsOnTopOfOlap = true;
        }
        return tabItemsOnTopOfOlap;
    }

    private String aggregateAccordingToOriginalOlapDI(V5BoundDataItemReference identifier) {
        V5DataItem dataItem = identifier.getRefDataItem();
        if (this.hasCalculationOrMeasureWithDefinedRegularAggregateOrImplicitMeasure(dataItem)) {
            return this.aggregateAccordingToRegularAggregateOfMeasureOrCalculated(dataItem);
        }
        return "none";
    }

    private String aggregateAccordingToRegularAggregateOfMeasureOrCalculated(IXQEQueryNode identifier) {
        IXQEQueryNode valueExpression = identifier.getChild(0).getChild(0);
        if (!this.isMeasureExpression(valueExpression) && !this.isFact(valueExpression)) {
            return "calculated";
        }
        int[] types = new int[]{201116};
        IXQEQueryNode[] modelReferences = identifier.getDescendantsOfTypes(types, false);
        V5BoundModelIdentifier modelIdentifier = (V5BoundModelIdentifier)modelReferences[0];
        String regularAggregateName = modelIdentifier.getRegularAggregate();
        if (regularAggregateName != null && !regularAggregateName.equals("unknown")) {
            if (regularAggregateName.equals("sum")) {
                return "total";
            }
            if (regularAggregateName.equals("unsupported")) {
                return "none";
            }
            return regularAggregateName;
        }
        return "calculated";
    }

    private boolean isMeasureExpression(IXQEQueryNode valueExpression) {
        return valueExpression.isOfCategory(201120) && ((V5SimpleNode)valueExpression).getHierarchyInfo().projectsMeasures();
    }

    private boolean isFact(IXQEQueryNode valueExpression) {
        V5BoundModelIdentifier identifier;
        if (valueExpression.isOfCategory(201116) && (identifier = (V5BoundModelIdentifier)valueExpression).getMetadata().getObjectType() == MetadataType.QUERY_ITEM) {
            IQueryItem queryItem = (IQueryItem)identifier.getMetadata();
            return queryItem.isFact();
        }
        return false;
    }

    private boolean hasReferenceToDataItemWithRollupAggregateAutomatic(IXQEQueryNode node) {
        IXQEQueryNode[] references;
        for (IXQEQueryNode reference : references = node.getDescendantsOfTypes(new int[]{201060, 201097}, false)) {
            String rollupAggregate;
            V5BoundMultiPartIdentifier identifier;
            V5DataItem dataItemRef = null;
            if (reference.getType() == 201060) {
                identifier = (V5BoundDataItemReference)reference;
                dataItemRef = ((V5BoundDataItemReference)identifier).getRefDataItem();
            } else {
                identifier = (V5BoundQueryItemReference)reference;
                dataItemRef = ((V5BoundQueryItemReference)identifier).getRefDataItem();
            }
            if (dataItemRef == null || (rollupAggregate = dataItemRef.getRollupAggregateProperty()) == null || !rollupAggregate.equals("automatic")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean flagScalarFunctionXTab;
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        V5Query query = (V5Query)v5DataItem.getAncestorOfType(101006);
        if (query == null || query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Relational query in the context of DMR.", trace);
            return false;
        }
        Boolean property = query.getV5Source().needQueryOverTabularStream();
        boolean bl = flagScalarFunctionXTab = property != null && property != false;
        if (!query.isTabular() && !query.isRelStyle() && !flagScalarFunctionXTab && this.hasTabularItemsOnTopOfOlap(node) || query.hasOlapOperand() || query.isDMR()) {
            String rollupAggregate = v5DataItem.getRollupAggregateProperty();
            String aggregate = v5DataItem.getAggregateProperty();
            if (rollupAggregate != null && rollupAggregate.compareTo("automatic") == 0 || aggregate != null && aggregate.compareTo("automatic") == 0) {
                if (query.isDMR() && MixedDMRRelUtil.containRelationals(v5DataItem, null)) {
                    this.traceNodeCondition(false, "This is a pure relational data item.", trace);
                    return false;
                }
                if (this.hasReferenceToDataItemWithRollupAggregateAutomatic(node)) {
                    this.traceNodeCondition(false, "This is a reference to a data item not yet evaluated.", trace);
                    return false;
                }
                this.traceNodeCondition(true, "This is a temp tabular item on top of olap datasouce", trace);
                return true;
            }
            this.traceNodeCondition(false, "This is an item with rollup different than automatic.", trace);
            return false;
        }
        this.traceNodeCondition(false, "This is a pure olap or pure rel item, should not be processed here.", trace);
        return false;
    }
}

